/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFWArray;

public class PDFCIDFont
extends PDFObject {
    public static final byte CID_TYPE0 = 0;
    public static final byte CID_TYPE2 = 1;
    protected static final String[] TYPE_NAMES = new String[]{"CIDFontType0", "CIDFontType2"};
    protected String basefont;
    protected String cidtype;
    protected Integer dw;
    protected PDFWArray w;
    protected int[] dw2;
    protected PDFWArray w2;
    protected PDFCIDSystemInfo systemInfo;
    protected PDFCIDFontDescriptor descriptor;
    protected PDFCMap cmap;
    protected PDFStream cidMap;

    public PDFCIDFont(int number, String basefont, byte cidtype, int dw, PDFWArray w, PDFCIDSystemInfo systemInfo, PDFCIDFontDescriptor descriptor) {
        super(number);
        this.basefont = basefont;
        this.cidtype = TYPE_NAMES[cidtype];
        this.dw = new Integer(dw);
        this.w = w;
        this.dw2 = null;
        this.w2 = null;
        this.systemInfo = systemInfo;
        this.descriptor = descriptor;
        this.cidMap = null;
        this.cmap = null;
    }

    public PDFCIDFont(int number, String basefont, byte cidtype, int dw, int[] w, String registry, String ordering, int supplement, PDFCIDFontDescriptor descriptor) {
        super(number);
        this.basefont = basefont;
        this.cidtype = TYPE_NAMES[cidtype];
        this.dw = new Integer(dw);
        this.w = new PDFWArray();
        this.w.addEntry(0, w);
        this.dw2 = null;
        this.w2 = null;
        this.systemInfo = new PDFCIDSystemInfo(registry, ordering, supplement);
        this.descriptor = descriptor;
        this.cidMap = null;
        this.cmap = null;
    }

    public void setCIDMap(PDFStream map) {
        this.cidMap = map;
    }

    public void setCIDMapIdentity() {
        this.cidMap = null;
    }

    public void setCMAP(PDFCMap cmap) {
        this.cmap = cmap;
    }

    public void setDW(int dw) {
        this.dw = new Integer(dw);
    }

    public void setDW2(int posY, int displacementY) {
        this.dw2 = new int[]{posY, displacementY};
    }

    public void setDW2(int[] dw2) {
        this.dw2 = dw2;
    }

    public void setW(PDFWArray w) {
        this.w = w;
    }

    public void setW2(PDFWArray w2) {
        this.w2 = w2;
    }

    public byte[] toPDF() {
        try {
            return this.toPDFString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.toPDFString().getBytes();
        }
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer();
        p.append(this.number);
        p.append(" ");
        p.append(this.generation);
        p.append(" obj\n<< /Type /Font");
        p.append("\n/BaseFont /");
        p.append(this.basefont);
        if (this.cidMap != null) {
            p.append(" \n/CIDToGIDMap ");
            p.append(this.cidMap.referencePDF());
        }
        p.append(" \n/Subtype /");
        p.append(this.cidtype);
        p.append("\n");
        p.append(this.systemInfo.toPDFString());
        p.append("\n/FontDescriptor ");
        p.append(this.descriptor.referencePDF());
        if (this.cmap != null) {
            p.append("\n/ToUnicode ");
            p.append(this.cmap.referencePDF());
        }
        if (this.dw != null) {
            p.append("\n/DW ");
            p.append(this.dw);
        }
        if (this.w != null) {
            p.append("\n/W ");
            p.append(this.w.toPDFString());
        }
        if (this.dw2 != null) {
            p.append("\n/DW2 [");
            p.append(this.dw2[0]);
            p.append(this.dw2[1]);
            p.append("] \n>>\nendobj\n");
        }
        if (this.w2 != null) {
            p.append("\n/W2 ");
            p.append(this.w2.toPDFString());
            p.append(" \n>>\nendobj\n");
        }
        p.append(" \n>>\nendobj\n");
        return p.toString();
    }
}

