/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;

public class DropRole
extends DefineCommand {
    private String roleName;
    private boolean ifExists;

    public DropRole(Session session) {
        super(session);
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.roleName.equals("PUBLIC")) {
            throw Message.getSQLException(90091, this.roleName);
        }
        Role role = db.findRole(this.roleName);
        if (role == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90070, this.roleName);
            }
        } else {
            db.removeDatabaseObject(this.session, role);
        }
        return 0;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }
}

