/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.derby.impl.load.LoadError;

class ColumnInfo {
    private ArrayList vtiColumnNames = new ArrayList(1);
    private ArrayList insertColumnNames = new ArrayList(1);
    private ArrayList columnTypes = new ArrayList(1);
    private ArrayList jdbcColumnTypes = new ArrayList(1);
    private int noOfColumns = 0;
    private ArrayList columnPositions;
    private boolean createolumnNames = true;
    private int expectedNumberOfCols;
    private Connection conn;
    private String tableName;
    private String schemaName;

    public ColumnInfo(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6;
        StringTokenizer stringTokenizer;
        this.conn = connection;
        this.schemaName = string;
        this.tableName = string2;
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken().trim();
                if (this.initializeColumnInfo(string6)) continue;
                if (this.tableExists()) {
                    throw LoadError.invalidColumnName(string6);
                }
                String string7 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
                throw LoadError.tableNotFound(string7);
            }
        } else if (!this.initializeColumnInfo(null)) {
            String string8 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
            throw LoadError.tableNotFound(string8);
        }
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken().trim();
                this.vtiColumnNames.add(string5 + string6);
                int n = new Integer(string6);
                if (n <= this.expectedNumberOfCols) continue;
                this.expectedNumberOfCols = n;
            }
        }
        if (this.vtiColumnNames.size() < 1) {
            for (int i = 1; i <= this.noOfColumns; ++i) {
                this.vtiColumnNames.add(string5 + i);
            }
            this.expectedNumberOfCols = this.noOfColumns;
        }
    }

    private boolean initializeColumnInfo(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, this.schemaName, this.tableName, string);
        boolean bl = false;
        while (resultSet.next()) {
            String string2 = resultSet.getString(4);
            short s = resultSet.getShort(5);
            String string3 = resultSet.getString(6);
            int n = resultSet.getInt(7);
            int n2 = resultSet.getInt(9);
            int n3 = resultSet.getInt(10);
            bl = true;
            if (ColumnInfo.importExportSupportedType(s)) {
                this.insertColumnNames.add(string2);
                String string4 = string3 + this.getTypeOption(string3, n, n, n2);
                this.columnTypes.add(string4);
                this.jdbcColumnTypes.add(new Integer(s));
                ++this.noOfColumns;
                continue;
            }
            resultSet.close();
            throw LoadError.nonSupportedTypeColumn(string2, string3);
        }
        resultSet.close();
        return bl;
    }

    public static final boolean importExportSupportedType(int n) {
        return n != -7 && n != 2000 && n != 1111 && n != 456;
    }

    private String getTypeOption(String string, int n, int n2, int n3) {
        if ((string.equals("CHAR") || string.equals("BLOB") || string.equals("CLOB") || string.equals("VARCHAR")) && n != 0) {
            return "(" + n + ")";
        }
        if (string.equals("FLOAT") && n2 != 0) {
            return "(" + n2 + ")";
        }
        if (string.equals("DECIMAL") || string.equals("NUMERIC")) {
            if (n2 != 0 && n3 == 0) {
                return "(" + n2 + ")";
            }
            if (n2 != 0 && n3 != 0) {
                return "(" + n2 + "," + n3 + ")";
            }
            if (n2 == 0 && n3 != 0) {
                return "(" + n3 + ")";
            }
        }
        if ((string.equals("DECIMAL") || string.equals("NUMERIC")) && n3 != 0) {
            return "(" + n3 + ")";
        }
        return "";
    }

    public String getColumnNamesWithCasts() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = this.vtiColumnNames.size();
        for (int i = 0; i < this.noOfColumns && i < n; ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            String string = (String)this.columnTypes.get(i);
            String string2 = (String)this.vtiColumnNames.get(i);
            if (string.startsWith("SMALLINT") || string.startsWith("INTEGER") || string.startsWith("DECIMAL") || string.startsWith("BIGINT") || string.startsWith("NUMERIC")) {
                stringBuffer.append(" cast(" + string2 + " AS " + string + ") ");
                continue;
            }
            if (string.startsWith("DOUBLE")) {
                stringBuffer.append(" DOUBLE(" + string2 + ") ");
                continue;
            }
            if (string.startsWith("REAL")) {
                stringBuffer.append("cast( DOUBLE(" + string2 + ") " + " AS " + "REAL" + ") ");
                continue;
            }
            stringBuffer.append(" " + string2 + " ");
        }
        if (bl) {
            return " * ";
        }
        return stringBuffer.toString();
    }

    public String getInsertColumnNames() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.noOfColumns; ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append("\"");
            stringBuffer.append(this.insertColumnNames.get(i));
            stringBuffer.append("\"");
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getExpectedNumberOfColumnsInFile() {
        return this.expectedNumberOfCols;
    }

    private boolean tableExists() throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, this.schemaName, this.tableName, null);
        boolean bl = false;
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        return bl;
    }

    public String getExpectedVtiColumnTypesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.noOfColumns && i < this.vtiColumnNames.size(); ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.vtiColumnNames.get(i) + ":" + this.jdbcColumnTypes.get(i));
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static int[] getExpectedVtiColumnTypes(String string, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 12;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(":");
            int n3 = new Integer(string2.substring(6, n2));
            int n4 = new Integer(string2.substring(n2 + 1));
            if (n3 > n) continue;
            nArray[n3 - 1] = n4;
        }
        return nArray;
    }
}

