/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.ExpressionVisitor;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public abstract class Expression {
    private boolean addedToFilter;

    public abstract Value getValue(Session var1) throws SQLException;

    public abstract int getType();

    public abstract void mapColumns(ColumnResolver var1, int var2) throws SQLException;

    public abstract Expression optimize(Session var1) throws SQLException;

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract int getScale();

    public abstract long getPrecision();

    public abstract String getSQL();

    public abstract void updateAggregate(Session var1) throws SQLException;

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract int getCost();

    public final boolean isEverything(int expressionVisitorType) {
        ExpressionVisitor visitor = ExpressionVisitor.get(expressionVisitorType);
        return this.isEverything(visitor);
    }

    public Expression getNotIfPossible(Session session) {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isValueSet() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public Boolean getBooleanValue(Session session) throws SQLException {
        return this.getValue(session).getBoolean();
    }

    public void createIndexConditions(Session session, TableFilter filter) throws SQLException {
    }

    public String getColumnName() {
        return this.getAlias();
    }

    public String getSchemaName() {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public int getNullable() {
        return 2;
    }

    public String getTableAlias() {
        return null;
    }

    public String getAlias() {
        return StringUtils.unEnclose(this.getSQL());
    }

    public boolean isWildcard() {
        return false;
    }

    public Expression getNonAliasExpression() {
        return this;
    }

    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (!this.addedToFilter && !outerJoin && this.isEverything(3)) {
            filter.addFilterCondition(this, false);
            this.addedToFilter = true;
        }
    }
}

