/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Iterator;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.ScanIndex;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class ScanCursor
implements Cursor {
    private ScanIndex scan;
    private Row row;
    private final Session session;
    private final boolean multiVersion;
    private Iterator delta;

    ScanCursor(Session session, ScanIndex scan, boolean multiVersion) {
        this.session = session;
        this.scan = scan;
        this.multiVersion = multiVersion;
        if (multiVersion) {
            this.delta = scan.getDelta();
        }
        this.row = null;
    }

    Session getSession() {
        return this.session;
    }

    public Row get() {
        return this.row;
    }

    public SearchRow getSearchRow() {
        return this.row;
    }

    public int getPos() {
        return this.row.getPos();
    }

    public boolean next() throws SQLException {
        if (this.multiVersion) {
            while (true) {
                if (this.delta.hasNext()) {
                    this.row = (Row)this.delta.next();
                    if (!this.row.getDeleted() || this.row.getSessionId() == this.session.getId()) {
                        this.row = null;
                        continue;
                    }
                } else {
                    this.row = this.scan.getNextRow(this.session, this.row);
                }
                if (this.row == null || this.row.getSessionId() == 0 || this.row.getSessionId() == this.session.getId() || this.row.getDeleted()) break;
            }
            return this.row != null;
        }
        this.row = this.scan.getNextRow(this.session, this.row);
        return this.row != null;
    }
}

