/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.message.Message;
import org.h2.util.ObjectUtils;

public class SmallMap {
    private HashMap map = new HashMap();
    private Object cache;
    private int cacheId;
    private int lastId;
    private int maxElements;

    public SmallMap(int maxElements) {
        this.maxElements = maxElements;
    }

    public int addObject(int id, Object o) {
        if (this.map.size() > this.maxElements * 2) {
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                Integer k = (Integer)it.next();
                if (k + this.maxElements >= this.lastId) continue;
                it.remove();
            }
        }
        if (id > this.lastId) {
            this.lastId = id;
        }
        this.map.put(ObjectUtils.getInteger(id), o);
        this.cacheId = id;
        this.cache = o;
        return id;
    }

    public void freeObject(int id) {
        if (this.cacheId == id) {
            this.cacheId = -1;
            this.cache = null;
        }
        this.map.remove(ObjectUtils.getInteger(id));
    }

    public Object getObject(int id, boolean ifAvailable) throws SQLException {
        if (id == this.cacheId) {
            return this.cache;
        }
        Object obj = this.map.get(ObjectUtils.getInteger(id));
        if (obj == null && !ifAvailable) {
            throw Message.getSQLException(90007);
        }
        return obj;
    }
}

