/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.desc;

import java.util.ArrayList;
import java.util.Collections;
import org.seasar.extension.jdbc.ColumnMeta;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDesc;
import org.seasar.extension.jdbc.gen.desc.PrimaryKeyDescFactory;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;

public class PrimaryKeyDescFactoryImpl
implements PrimaryKeyDescFactory {
    protected GenDialect dialect;

    public PrimaryKeyDescFactoryImpl(GenDialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    public PrimaryKeyDesc getPrimaryKeyDesc(EntityMeta entityMeta) {
        if (entityMeta.getIdPropertyMetaList().isEmpty()) {
            return null;
        }
        PrimaryKeyDesc primaryKeyDesc = new PrimaryKeyDesc();
        this.doColumnName(entityMeta, primaryKeyDesc);
        return primaryKeyDesc;
    }

    protected void doColumnName(EntityMeta entityMeta, PrimaryKeyDesc primaryKeyDesc) {
        ArrayList classList = new ArrayList();
        for (Class clazz = entityMeta.getEntityClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            classList.add(clazz);
        }
        Collections.reverse(classList);
        for (Class clazz : classList) {
            for (PropertyMeta propertyMeta : entityMeta.getIdPropertyMetaList()) {
                if (clazz != propertyMeta.getField().getDeclaringClass()) continue;
                ColumnMeta columnMeta = propertyMeta.getColumnMeta();
                primaryKeyDesc.addColumnName(columnMeta.getName());
            }
        }
    }
}

