/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.easymock.ArgumentsMatcher;
import org.easymock.IAnswer;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;
import org.easymock.internal.ThrowableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayState
implements IMocksControlState,
Serializable {
    private static final long serialVersionUID = 6314142602251047572L;
    private IMocksBehavior behavior;

    public ReplayState(IMocksBehavior behavior) {
        this.behavior = behavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        if (this.behavior.isThreadSafe()) {
            ReplayState replayState = this;
            synchronized (replayState) {
                return this.invokeInner(invocation);
            }
        }
        this.behavior.checkCurrentThreadSameAsLastThread();
        return this.invokeInner(invocation);
    }

    private Object invokeInner(Invocation invocation) throws Throwable {
        Result result = this.behavior.addActual(invocation);
        LastControl.pushCurrentArguments(invocation.getArguments());
        try {
            Object object = result.answer();
            return object;
        }
        catch (Throwable t) {
            throw new ThrowableWrapper(t);
        }
        finally {
            LastControl.popCurrentArguments();
        }
    }

    @Override
    public void verify() {
        this.behavior.verify();
    }

    @Override
    public void replay() {
        this.throwWrappedIllegalStateException();
    }

    public void callback(Runnable runnable) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void checkOrder(boolean value) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void makeThreadSafe(boolean threadSafe) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andReturn(Object value) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andThrow(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andAnswer(IAnswer<?> answer) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andStubReturn(Object value) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andStubThrow(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void andStubAnswer(IAnswer<?> answer) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void asStub() {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void times(Range range) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void setMatcher(Method method, ArgumentsMatcher matcher) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void setDefaultReturnValue(Object value) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void setDefaultThrowable(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    @Override
    public void setDefaultVoidCallable() {
        this.throwWrappedIllegalStateException();
    }

    private void throwWrappedIllegalStateException() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("This method must not be called in replay state."));
    }

    @Override
    public void assertRecordState() {
        this.throwWrappedIllegalStateException();
    }
}

