/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.argtype;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.extension.jdbc.gen.internal.argtype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.argtype.CharacterType;
import org.seasar.extension.jdbc.gen.internal.argtype.ClassType;
import org.seasar.extension.jdbc.gen.internal.argtype.CollectionType;
import org.seasar.extension.jdbc.gen.internal.argtype.EnumType;
import org.seasar.extension.jdbc.gen.internal.argtype.FileType;
import org.seasar.extension.jdbc.gen.internal.argtype.ListType;
import org.seasar.extension.jdbc.gen.internal.argtype.NumberType;
import org.seasar.extension.jdbc.gen.internal.argtype.SetType;
import org.seasar.extension.jdbc.gen.internal.argtype.StringType;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentTypeRegistry {
    protected static Map<Class<?>, Constructor<? extends ArgumentType<?>>> argTypeMap = new ConcurrentHashMap();
    protected static Map<Class<? extends Collection>, Constructor<? extends CollectionType>> collectionArgTypeMap;

    public static <T> ArgumentType<T> getArgumentType(PropertyDesc propertyDesc) {
        Class propertyType = propertyDesc.getPropertyType();
        if (propertyDesc.isParameterized() && Collection.class.isAssignableFrom(propertyType)) {
            Class elementClass = propertyDesc.getElementClassOfCollection();
            return ArgumentTypeRegistry.getCollectionArgumentType(propertyType, elementClass);
        }
        return ArgumentTypeRegistry.getArgumentType(propertyType);
    }

    protected static <T> ArgumentType<T> getArgumentType(Class<?> clazz) {
        if (argTypeMap.containsKey(clazz = ClassUtil.getWrapperClassIfPrimitive(clazz))) {
            Constructor<? extends ArgumentType<?>> constructor = argTypeMap.get(clazz);
            return (ArgumentType)ReflectionUtil.newInstance(constructor, null);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumberType(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumType(clazz);
        }
        return null;
    }

    protected static <T> ArgumentType<T> getCollectionArgumentType(Class<?> collectioinClass, Class<?> elementClass) {
        ArgumentType<T> argumentType = ArgumentTypeRegistry.getArgumentType(elementClass);
        if (collectionArgTypeMap.containsKey(collectioinClass)) {
            Constructor<? extends CollectionType> constructor = collectionArgTypeMap.get(collectioinClass);
            return (ArgumentType)ReflectionUtil.newInstance(constructor, (Object[])new Object[]{argumentType});
        }
        return null;
    }

    public static void registerArgumentType(Class<?> clazz, Class<? extends ArgumentType<?>> argumentTypeClass) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (argumentTypeClass == null) {
            throw new NullPointerException("argumentTypeClass");
        }
        Constructor constructor = ReflectionUtil.getConstructor(argumentTypeClass, null);
        argTypeMap.put(clazz, constructor);
    }

    public static void deregisterArgumentType(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        argTypeMap.remove(clazz);
    }

    public static void registerCollectionArgumentType(Class<? extends Collection> collectionClass, Class<? extends CollectionType> argumentTypeClass) {
        if (collectionClass == null) {
            throw new NullPointerException("collectionClass");
        }
        if (argumentTypeClass == null) {
            throw new NullPointerException("argumentTypeClass");
        }
        Constructor constructor = ReflectionUtil.getConstructor(argumentTypeClass, (Class[])new Class[]{ArgumentType.class});
        collectionArgTypeMap.put(collectionClass, constructor);
    }

    public static void deregisterCollectionArgumentType(Class<? extends Collection> collectionClass) {
        if (collectionClass == null) {
            throw new NullPointerException("collectionClass");
        }
        collectionArgTypeMap.remove(collectionClass);
    }

    static {
        argTypeMap.put(Boolean.class, ReflectionUtil.getConstructor(BooleanType.class, null));
        argTypeMap.put(Character.class, ReflectionUtil.getConstructor(CharacterType.class, null));
        argTypeMap.put(String.class, ReflectionUtil.getConstructor(StringType.class, null));
        argTypeMap.put(File.class, ReflectionUtil.getConstructor(FileType.class, null));
        argTypeMap.put(Class.class, ReflectionUtil.getConstructor(ClassType.class, null));
        collectionArgTypeMap = new ConcurrentHashMap<Class<? extends Collection>, Constructor<? extends CollectionType>>();
        collectionArgTypeMap.put(List.class, ReflectionUtil.getConstructor(ListType.class, (Class[])new Class[]{ArgumentType.class}));
        collectionArgTypeMap.put(Set.class, ReflectionUtil.getConstructor(SetType.class, (Class[])new Class[]{ArgumentType.class}));
        collectionArgTypeMap.put(Collection.class, ReflectionUtil.getConstructor(CollectionType.class, (Class[])new Class[]{ArgumentType.class}));
    }
}

