/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExecutionContextImpl
implements SqlExecutionContext {
    protected static final Logger logger = Logger.getLogger(SqlExecutionContextImpl.class);
    protected List<RuntimeException> exceptionList = new ArrayList<RuntimeException>();
    protected DataSource dataSource;
    protected Connection connection;
    protected boolean haltOnError;
    protected Statement statement;
    protected PreparedStatement preparedStatement;
    protected boolean localTx;
    protected boolean failed;
    protected boolean begun;

    public SqlExecutionContextImpl(DataSource dataSource, boolean localTx, boolean haltOnError) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        this.dataSource = dataSource;
        this.localTx = localTx;
        this.haltOnError = haltOnError;
        this.openConnection();
    }

    @Override
    public boolean isHaltOnError() {
        return this.haltOnError;
    }

    @Override
    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    @Override
    public Statement getStatement() {
        this.assertBegun();
        this.assertConnectionNotNull();
        this.statement = ConnectionUtil.createStatement((Connection)this.connection);
        return this.statement;
    }

    @Override
    public PreparedStatement getPreparedStatement(String sql) {
        this.assertBegun();
        this.assertConnectionNotNull();
        this.preparedStatement = ConnectionUtil.prepareStatement((Connection)this.connection, (String)sql);
        return this.preparedStatement;
    }

    @Override
    public List<RuntimeException> getExceptionList() {
        return Collections.unmodifiableList(this.exceptionList);
    }

    @Override
    public void addException(RuntimeException exception) {
        this.assertBegun();
        this.assertConnectionNotNull();
        this.failed = true;
        if (this.haltOnError) {
            throw exception;
        }
        logger.log("DS2JDBCGen0020", new Object[]{exception});
        this.exceptionList.add(exception);
    }

    @Override
    public void notifyException() {
        this.assertBegun();
        this.assertConnectionNotNull();
        this.failed = true;
    }

    @Override
    public void destroy() {
        this.assertNotBegun();
        this.exceptionList.clear();
        this.closeConnection();
    }

    @Override
    public void begin() {
        this.assertNotBegun();
        this.begun = true;
        this.assertConnectionNotNull();
        if (this.localTx) {
            try {
                this.connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
    }

    @Override
    public void end() {
        this.assertBegun();
        this.begun = false;
        this.assertConnectionNotNull();
        this.closeStatements();
        if (this.localTx) {
            if (this.failed) {
                try {
                    this.rollbackLocalTxInternal();
                }
                catch (SQLException e) {
                    this.closeConnection();
                    throw new SQLRuntimeException(e);
                }
            }
            try {
                this.commitLocalTxInternal();
            }
            catch (SQLException e) {
                this.closeConnection();
                throw new SQLRuntimeException(e);
            }
            try {
                if (!this.connection.isClosed()) {
                    this.connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                this.closeConnection();
                throw new SQLRuntimeException(e);
            }
        }
        if (this.failed) {
            this.closeConnection();
            this.openConnection();
        }
        this.failed = false;
    }

    @Override
    public void commitLocalTx() {
        if (this.localTx) {
            try {
                this.commitLocalTxInternal();
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
    }

    protected void rollbackLocalTxInternal() throws SQLException {
        if (!this.connection.isClosed()) {
            this.connection.rollback();
        }
    }

    protected void commitLocalTxInternal() throws SQLException {
        if (!this.connection.isClosed()) {
            this.connection.commit();
        }
    }

    protected void closeStatements() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException ignore) {
                logger.log((Throwable)ignore);
            }
            this.statement = null;
        }
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException ignore) {
                logger.log((Throwable)ignore);
            }
            this.preparedStatement = null;
        }
    }

    protected void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException ignore) {
                logger.log((Throwable)ignore);
            }
            this.connection = null;
        }
    }

    protected void openConnection() {
        this.connection = DataSourceUtil.getConnection((DataSource)this.dataSource);
    }

    protected void assertConnectionNotNull() {
        if (this.connection == null) {
            throw new AssertionError((Object)"connection must be opened.");
        }
    }

    protected void assertBegun() {
        if (!this.begun) {
            throw new AssertionError((Object)"this context must has been begun.");
        }
    }

    protected void assertNotBegun() {
        if (this.begun) {
            throw new AssertionError((Object)"this context must not has been begun.");
        }
    }
}

