/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.BooleanConversionUtil;

public class BooleanType
extends AbstractSqlType {
    public BooleanType() {
        this("boolean");
    }

    public BooleanType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 16);
        } else {
            ps.setBoolean(index, BooleanConversionUtil.toPrimitiveBoolean((Object)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Boolean value = BooleanConversionUtil.toBoolean((Object)resultSet.getObject(index));
        return value != null ? value.toString() : null;
    }
}

