/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seasar.extension.jdbc.gen.desc.AssociationDesc;
import org.seasar.extension.jdbc.gen.desc.AttributeDesc;
import org.seasar.extension.jdbc.gen.desc.CompositeUniqueConstraintDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDesc {
    protected String name;
    protected String catalogName;
    protected String schemaName;
    protected String tableName;
    protected boolean compositeId;
    protected String comment;
    protected List<AttributeDesc> attributeDescList = new ArrayList<AttributeDesc>();
    protected List<AttributeDesc> idAttributeDescList = new ArrayList<AttributeDesc>();
    protected List<AssociationDesc> associationDescList = new ArrayList<AssociationDesc>();
    protected List<CompositeUniqueConstraintDesc> compositeUniqueConstraintDescList = new ArrayList<CompositeUniqueConstraintDesc>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFullTableName() {
        StringBuilder buf = new StringBuilder();
        if (this.catalogName != null) {
            buf.append(this.catalogName).append(".");
        }
        if (this.schemaName != null) {
            buf.append(this.schemaName).append(".");
        }
        return buf.append(this.tableName).toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void addAttributeDesc(AttributeDesc attributeDesc) {
        this.attributeDescList.add(attributeDesc);
        if (attributeDesc.isId()) {
            this.idAttributeDescList.add(attributeDesc);
        }
    }

    public List<AttributeDesc> getAttributeDescList() {
        return Collections.unmodifiableList(this.attributeDescList);
    }

    public boolean hasAttributeDesc(String attributeName) {
        for (AttributeDesc attributeDesc : this.attributeDescList) {
            if (!attributeDesc.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public List<AttributeDesc> getIdAttributeDescList() {
        return Collections.unmodifiableList(this.idAttributeDescList);
    }

    public List<AssociationDesc> getAssociationDescList() {
        return Collections.unmodifiableList(this.associationDescList);
    }

    public void addAssociationDesc(AssociationDesc associationDesc) {
        this.associationDescList.add(associationDesc);
    }

    public boolean hasAssociationDesc(String associationName) {
        for (AssociationDesc associationDesc : this.associationDescList) {
            if (!associationDesc.getName().equals(associationName)) continue;
            return true;
        }
        return false;
    }

    public List<CompositeUniqueConstraintDesc> getCompositeUniqueConstraintDescList() {
        return Collections.unmodifiableList(this.compositeUniqueConstraintDescList);
    }

    public void addCompositeUniqueConstraintDesc(CompositeUniqueConstraintDesc compositeUniqueConstraintDesc) {
        this.compositeUniqueConstraintDescList.add(compositeUniqueConstraintDesc);
    }

    public boolean hasCompositeId() {
        return this.idAttributeDescList.size() > 1;
    }
}

