/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.FloatType;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db2GenDialect
extends StandardGenDialect {
    protected static String TABLE_NOT_FOUND_SQL_STATE = "42704";
    protected static String COLUMN_NOT_FOUND_SQL_STATE = "42703";
    protected static String SEQUENCE_NOT_FOUND_SQL_STATE = "42704";

    public Db2GenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("varchar($l) for bit data"));
        this.sqlTypeMap.put(2004, new BlobType("blob($l)"));
        this.sqlTypeMap.put(16, new BooleanType("smallint"));
        this.sqlTypeMap.put(2005, new ClobType("clob($l)"));
        this.sqlTypeMap.put(3, new DecimalType("decimal($p,$s)"));
        this.sqlTypeMap.put(6, new FloatType("real"));
        this.columnTypeMap.put("blob", Db2ColumnType.BLOB);
        this.columnTypeMap.put("char () for bit data", Db2ColumnType.CHAR_BIT);
        this.columnTypeMap.put("clob", Db2ColumnType.CLOB);
        this.columnTypeMap.put("decimal", Db2ColumnType.DECIMAL);
        this.columnTypeMap.put("long varchar for bit data", Db2ColumnType.LONGVARCHAR_BIT);
        this.columnTypeMap.put("long varchar", Db2ColumnType.LONGVARCHAR);
        this.columnTypeMap.put("varchar () for bit data", Db2ColumnType.VARCHAR_BIT);
    }

    @Override
    public String getName() {
        return "db2";
    }

    @Override
    public String getDefaultSchemaName(String userName) {
        return userName != null ? userName.toUpperCase() : null;
    }

    @Override
    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public String getSequenceDefinitionFragment(String dataType, long initialValue, int allocationSize) {
        return "as " + dataType + " start with " + initialValue + " increment by " + allocationSize;
    }

    @Override
    public String getIdentityColumnDefinition() {
        return "generated by default as identity";
    }

    @Override
    public String getSqlBlockDelimiter() {
        return "@";
    }

    @Override
    public boolean isTableNotFound(Throwable t) {
        for (SQLException e : this.getAllSQLExceptions(t)) {
            if (!TABLE_NOT_FOUND_SQL_STATE.equals(e.getSQLState())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnNotFound(Throwable t) {
        for (SQLException e : this.getAllSQLExceptions(t)) {
            if (!COLUMN_NOT_FOUND_SQL_STATE.equals(e.getSQLState())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSequenceNotFound(Throwable t) {
        for (SQLException e : this.getAllSQLExceptions(t)) {
            if (!SEQUENCE_NOT_FOUND_SQL_STATE.equals(e.getSQLState())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsIdentityInsert() {
        return true;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    protected List<SQLException> getAllSQLExceptions(Throwable t) {
        ArrayList<SQLException> sqlExceptionList = new ArrayList<SQLException>();
        while (t != null) {
            if (t instanceof SQLException) {
                SQLException cause = (SQLException)SQLException.class.cast(t);
                sqlExceptionList.add(cause);
                if (cause.getNextException() != null) {
                    cause = cause.getNextException();
                    sqlExceptionList.add(cause);
                    t = cause;
                    continue;
                }
            }
            t = t.getCause();
        }
        return sqlExceptionList;
    }

    @Override
    public GenDialect.SqlBlockContext createSqlBlockContext() {
        return new Db2SqlBlockContext();
    }

    @Override
    public boolean supportsNullableUnique() {
        return false;
    }

    @Override
    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "values nextval for " + sequenceName;
    }

    @Override
    public boolean supportsCommentInCreateTable() {
        return false;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoIncrement(Connection connection, String catalogName, String schemaName, String tableName, String columnName) throws SQLException {
        String sql = "select generated from syscat.columns where tabschema = ? and tabname = ? and colname = ?";
        logger.debug((Object)String.format(sql.replace("?", "'%s'"), schemaName, tableName, columnName));
        PreparedStatement ps = ConnectionUtil.prepareStatement((Connection)connection, (String)sql);
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, columnName);
        try {
            ResultSet rs;
            block8: {
                boolean bl;
                rs = ps.executeQuery();
                try {
                    if (!rs.next()) break block8;
                    String generated = rs.getString(1);
                    bl = "A".equals(generated) || "D".equals(generated);
                }
                catch (Throwable throwable) {
                    ResultSetUtil.close((ResultSet)rs);
                    throw throwable;
                }
                ResultSetUtil.close((ResultSet)rs);
                return bl;
            }
            boolean bl = false;
            ResultSetUtil.close((ResultSet)rs);
            return bl;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }

    public static class Db2SqlBlockContext
    extends StandardGenDialect.StandardSqlBlockContext {
        protected Db2SqlBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "trigger"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Db2ColumnType
    extends StandardGenDialect.StandardColumnType {
        private static Db2ColumnType BLOB = new Db2ColumnType("blob($l)", byte[].class);
        private static Db2ColumnType CHAR_BIT = new Db2ColumnType("char($l) for bit data", byte[].class);
        private static Db2ColumnType CLOB = new Db2ColumnType("clob($l)", String.class);
        private static Db2ColumnType DECIMAL = new Db2ColumnType("decimal($p,$s)", BigDecimal.class);
        private static Db2ColumnType LONGVARCHAR_BIT = new Db2ColumnType("long varchar for bit data", byte[].class);
        private static Db2ColumnType LONGVARCHAR = new Db2ColumnType("long varchar", String.class);
        private static Db2ColumnType VARCHAR_BIT = new Db2ColumnType("varchar($l) for bit data", byte[].class);

        public Db2ColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public Db2ColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

