/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.seasar.extension.jdbc.gen.data.Dumper;
import org.seasar.extension.jdbc.gen.desc.DatabaseDesc;
import org.seasar.extension.jdbc.gen.desc.DatabaseDescFactory;
import org.seasar.extension.jdbc.gen.desc.TableDesc;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.event.GenDdlListener;
import org.seasar.extension.jdbc.gen.generator.GenerationContext;
import org.seasar.extension.jdbc.gen.generator.Generator;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.event.GenDdlListenerImpl;
import org.seasar.extension.jdbc.gen.internal.exception.RequiredPropertyNullRuntimeException;
import org.seasar.extension.jdbc.gen.internal.util.ReflectUtil;
import org.seasar.extension.jdbc.gen.meta.EntityMetaReader;
import org.seasar.extension.jdbc.gen.model.DdlModel;
import org.seasar.extension.jdbc.gen.model.SqlIdentifierCaseType;
import org.seasar.extension.jdbc.gen.model.SqlKeywordCaseType;
import org.seasar.extension.jdbc.gen.model.TableModel;
import org.seasar.extension.jdbc.gen.model.TableModelFactory;
import org.seasar.extension.jdbc.gen.provider.ValueTypeProvider;
import org.seasar.extension.jdbc.gen.sql.SqlExecutionContext;
import org.seasar.extension.jdbc.gen.sql.SqlUnitExecutor;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectory;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectoryTree;
import org.seasar.extension.jdbc.gen.version.DdlVersionIncrementer;
import org.seasar.extension.jdbc.gen.version.ManagedFile;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateDdlCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(GenerateDdlCommand.class);
    protected File classpathDir;
    protected String rootPackageName = "";
    protected String entityPackageName = "entity";
    protected String entityClassNamePattern = ".*";
    protected String ignoreEntityClassNamePattern = "";
    protected String createTableDirName = "010-table";
    protected String createUniqueKeyDirName = "020-uniquekey";
    protected String createSequenceDirName = "030-sequence";
    protected String createForeignKeyDirName = "050-foreignkey";
    protected String createAuxiliaryDirName = "060-auxiliary";
    protected String dropAuxiliaryDirName = "050-auxiliary";
    protected String dropTableDirName = "040-table";
    protected String dropUniqueKeyDirName = "030-uniquekey";
    protected String dropSequenceDirName = "020-sequence";
    protected String dropForeignKeyDirName = "010-foreignkey";
    protected String ddlFileEncoding = "UTF-8";
    protected SqlKeywordCaseType sqlKeywordCaseType = SqlKeywordCaseType.ORIGINALCASE;
    protected SqlIdentifierCaseType sqlIdentifierCaseType = SqlIdentifierCaseType.ORIGINALCASE;
    protected boolean dump = true;
    protected String dumpDirName = "040-dump";
    protected String dumpFileEncoding = "UTF-8";
    protected String createTableTemplateFileName = "sql/create-table.ftl";
    protected String createUniqueKeyTemplateFileName = "sql/create-uniquekey.ftl";
    protected String createSequenceTemplateFileName = "sql/create-sequence.ftl";
    protected String createForeignKeyTemplateFileName = "sql/create-foreignkey.ftl";
    protected String createAuxiliaryTemplateFileName = "sql/create-auxiliary.ftl";
    protected String dropTableTemplateFileName = "sql/drop-table.ftl";
    protected String dropUniqueKeyTemplateFileName = "sql/drop-uniquekey.ftl";
    protected String dropSequenceTemplateFileName = "sql/drop-sequence.ftl";
    protected String dropForeignKeyTemplateFileName = "sql/drop-foreignkey.ftl";
    protected String dropAuxiliaryTemplateFileName = "sql/drop-auxiliary.ftl";
    protected String templateFileEncoding = "UTF-8";
    protected File templateFilePrimaryDir = null;
    protected File migrateDir = new File("db", "migrate");
    protected File ddlInfoFile = new File("db", "ddl-info.txt");
    protected String versionNoPattern = "0000";
    protected char statementDelimiter = (char)59;
    protected String tableOption = null;
    protected boolean applyJavaCommentToDdl = false;
    protected List<File> javaFileSrcDirList = new ArrayList<File>();
    protected String javaFileEncoding;
    protected boolean autoGenerateForeignKey;
    protected String comment;
    protected String genDialectClassName;
    protected String genDdlListenerClassName;
    protected boolean transactional;
    protected UserTransaction userTransaction;
    protected GenDialect dialect;
    protected ValueTypeProvider valueTypeProvider;
    protected EntityMetaReader entityMetaReader;
    protected TableModelFactory tableModelFactory;
    protected Generator generator;
    protected DdlVersionDirectoryTree ddlVersionDirectoryTree;
    protected GenDdlListener genDdlListener;
    protected DdlVersionIncrementer ddlVersionIncrementer;
    protected DatabaseDescFactory databaseDescFactory;
    protected SqlUnitExecutor sqlUnitExecutor;
    protected Dumper dumper;

    public GenerateDdlCommand() {
        File defaultSrcDir = new File(new File("src", "main"), "java");
        this.javaFileSrcDirList.add(defaultSrcDir);
        this.javaFileEncoding = "UTF-8";
        this.autoGenerateForeignKey = true;
        this.comment = "";
        this.genDialectClassName = null;
        this.genDdlListenerClassName = GenDdlListenerImpl.class.getName();
        this.transactional = false;
    }

    public File getClasspathDir() {
        return this.classpathDir;
    }

    public void setClasspathDir(File classpathDir) {
        this.classpathDir = classpathDir;
    }

    public String getCreateTableTemplateFileName() {
        return this.createTableTemplateFileName;
    }

    public void setCreateTableTemplateFileName(String createTableTemplateFileName) {
        this.createTableTemplateFileName = createTableTemplateFileName;
    }

    public String getCreateSequenceTemplateFileName() {
        return this.createSequenceTemplateFileName;
    }

    public void setCreateSequenceTemplateFileName(String createSequenceTemplateFileName) {
        this.createSequenceTemplateFileName = createSequenceTemplateFileName;
    }

    public String getCreateAuxiliaryTemplateFileName() {
        return this.createAuxiliaryTemplateFileName;
    }

    public void setCreateAuxiliaryTemplateFileName(String createAuxiliaryTemplateFileName) {
        this.createAuxiliaryTemplateFileName = createAuxiliaryTemplateFileName;
    }

    public String getDropTableTemplateFileName() {
        return this.dropTableTemplateFileName;
    }

    public void setDropTableTemplateFileName(String dropTableTemplateFileName) {
        this.dropTableTemplateFileName = dropTableTemplateFileName;
    }

    public String getDropSequenceTemplateFileName() {
        return this.dropSequenceTemplateFileName;
    }

    public void setDropSequenceTemplateFileName(String dropSequenceTemplateFileName) {
        this.dropSequenceTemplateFileName = dropSequenceTemplateFileName;
    }

    public String getCreateUniqueKeyTemplateFileName() {
        return this.createUniqueKeyTemplateFileName;
    }

    public void setCreateUniqueKeyTemplateFileName(String createUniqueKeyTemplateFileName) {
        this.createUniqueKeyTemplateFileName = createUniqueKeyTemplateFileName;
    }

    public String getCreateForeignKeyTemplateFileName() {
        return this.createForeignKeyTemplateFileName;
    }

    public void setCreateForeignKeyTemplateFileName(String createForeignKeyTemplateFileName) {
        this.createForeignKeyTemplateFileName = createForeignKeyTemplateFileName;
    }

    public String getDropForeignKeyTemplateFileName() {
        return this.dropForeignKeyTemplateFileName;
    }

    public void setDropForeignKeyTemplateFileName(String dropForeignKeyTemplateFileName) {
        this.dropForeignKeyTemplateFileName = dropForeignKeyTemplateFileName;
    }

    public String getDropUniqueKeyTemplateFileName() {
        return this.dropUniqueKeyTemplateFileName;
    }

    public void setDropUniqueKeyTemplateFileName(String dropUniqueKeyTemplateFileName) {
        this.dropUniqueKeyTemplateFileName = dropUniqueKeyTemplateFileName;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public String getEntityClassNamePattern() {
        return this.entityClassNamePattern;
    }

    public void setEntityClassNamePattern(String entityClassNamePattern) {
        this.entityClassNamePattern = entityClassNamePattern;
    }

    public String getIgnoreEntityClassNamePattern() {
        return this.ignoreEntityClassNamePattern;
    }

    public void setIgnoreEntityClassNamePattern(String ignoreEntityClassNamePattern) {
        this.ignoreEntityClassNamePattern = ignoreEntityClassNamePattern;
    }

    public char getStatementDelimiter() {
        return this.statementDelimiter;
    }

    public void setStatementDelimiter(char statementDelimiter) {
        this.statementDelimiter = statementDelimiter;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public File getMigrateDir() {
        return this.migrateDir;
    }

    public void setMigrateDir(File migrateDir) {
        this.migrateDir = migrateDir;
    }

    public String getDdlFileEncoding() {
        return this.ddlFileEncoding;
    }

    public void setDdlFileEncoding(String ddlFileEncoding) {
        this.ddlFileEncoding = ddlFileEncoding;
    }

    public String getTemplateFileEncoding() {
        return this.templateFileEncoding;
    }

    public void setTemplateFileEncoding(String templateFileEncoding) {
        this.templateFileEncoding = templateFileEncoding;
    }

    public File getTemplateFilePrimaryDir() {
        return this.templateFilePrimaryDir;
    }

    public void setTemplateFilePrimaryDir(File templateFilePrimaryDir) {
        this.templateFilePrimaryDir = templateFilePrimaryDir;
    }

    public File getDdlInfoFile() {
        return this.ddlInfoFile;
    }

    public void setDdlInfoFile(File ddlInfoFile) {
        this.ddlInfoFile = ddlInfoFile;
    }

    public String getVersionNoPattern() {
        return this.versionNoPattern;
    }

    public void setVersionNoPattern(String versionNoPattern) {
        this.versionNoPattern = versionNoPattern;
    }

    public String getDumpDirName() {
        return this.dumpDirName;
    }

    public void setDumpDirName(String dumpDirName) {
        this.dumpDirName = dumpDirName;
    }

    public String getTableOption() {
        return this.tableOption;
    }

    public void setTableOption(String tableOption) {
        this.tableOption = tableOption;
    }

    public boolean isApplyJavaCommentToDdl() {
        return this.applyJavaCommentToDdl;
    }

    public void setApplyJavaCommentToDdl(boolean applyJavaCommentToDdl) {
        this.applyJavaCommentToDdl = applyJavaCommentToDdl;
    }

    public List<File> getJavaFileSrcDirList() {
        return this.javaFileSrcDirList;
    }

    public void setJavaFileSrcDirList(List<File> javaFileSrcDirList) {
        this.javaFileSrcDirList = javaFileSrcDirList;
    }

    public String getJavaFileEncoding() {
        return this.javaFileEncoding;
    }

    public void setJavaFileEncoding(String javaFileEncoding) {
        this.javaFileEncoding = javaFileEncoding;
    }

    public String getDumpFileEncoding() {
        return this.dumpFileEncoding;
    }

    public void setDumpFileEncoding(String dumpFileEncoding) {
        this.dumpFileEncoding = dumpFileEncoding;
    }

    public boolean isDump() {
        return this.dump;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public SqlKeywordCaseType getSqlKeywordCaseType() {
        return this.sqlKeywordCaseType;
    }

    public void setSqlKeywordCaseType(SqlKeywordCaseType sqlKeywordCaseType) {
        this.sqlKeywordCaseType = sqlKeywordCaseType;
    }

    public SqlIdentifierCaseType getSqlIdentifierCaseType() {
        return this.sqlIdentifierCaseType;
    }

    public void setSqlIdentifierCaseType(SqlIdentifierCaseType sqlIdentifierCaseType) {
        this.sqlIdentifierCaseType = sqlIdentifierCaseType;
    }

    public String getGenDialectClassName() {
        return this.genDialectClassName;
    }

    public void setGenDialectClassName(String genDialectClassName) {
        this.genDialectClassName = genDialectClassName;
    }

    public String getCreateTableDirName() {
        return this.createTableDirName;
    }

    public void setCreateTableDirName(String createTableDirName) {
        this.createTableDirName = createTableDirName;
    }

    public String getCreateUniqueKeyDirName() {
        return this.createUniqueKeyDirName;
    }

    public void setCreateUniqueKeyDirName(String createUniqueKeyDirName) {
        this.createUniqueKeyDirName = createUniqueKeyDirName;
    }

    public String getCreateSequenceDirName() {
        return this.createSequenceDirName;
    }

    public void setCreateSequenceDirName(String createSequenceDirName) {
        this.createSequenceDirName = createSequenceDirName;
    }

    public String getCreateForeignKeyDirName() {
        return this.createForeignKeyDirName;
    }

    public void setCreateForeignKeyDirName(String createForeignKeyDirName) {
        this.createForeignKeyDirName = createForeignKeyDirName;
    }

    public String getDropTableDirName() {
        return this.dropTableDirName;
    }

    public void setDropTableDirName(String dropTableDirName) {
        this.dropTableDirName = dropTableDirName;
    }

    public String getDropUniqueKeyDirName() {
        return this.dropUniqueKeyDirName;
    }

    public void setDropUniqueKeyDirName(String dropUniqueKeyDirName) {
        this.dropUniqueKeyDirName = dropUniqueKeyDirName;
    }

    public String getDropSequenceDirName() {
        return this.dropSequenceDirName;
    }

    public void setDropSequenceDirName(String dropSequenceDirName) {
        this.dropSequenceDirName = dropSequenceDirName;
    }

    public String getDropForeignKeyDirName() {
        return this.dropForeignKeyDirName;
    }

    public void setDropForeignKeyDirName(String dropForeignKeyDirName) {
        this.dropForeignKeyDirName = dropForeignKeyDirName;
    }

    public String getGenDdlListenerClassName() {
        return this.genDdlListenerClassName;
    }

    public void setGenDdlListenerClassName(String genDdlListenerClassName) {
        this.genDdlListenerClassName = genDdlListenerClassName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isAutoGenerateForeignKey() {
        return this.autoGenerateForeignKey;
    }

    public void setAutoGenerateForeignKey(boolean autoGenerateForeignKey) {
        this.autoGenerateForeignKey = autoGenerateForeignKey;
    }

    public String getCreateAuxiliaryDirName() {
        return this.createAuxiliaryDirName;
    }

    public void setCreateAuxiliaryDirName(String createAuxiliaryDirName) {
        this.createAuxiliaryDirName = createAuxiliaryDirName;
    }

    public String getDropAuxiliaryDirName() {
        return this.dropAuxiliaryDirName;
    }

    public void setDropAuxiliaryDirName(String dropAuxiliaryDirName) {
        this.dropAuxiliaryDirName = dropAuxiliaryDirName;
    }

    public String getDropAuxiliaryTemplateFileName() {
        return this.dropAuxiliaryTemplateFileName;
    }

    public void setDropAuxiliaryTemplateFileName(String dropAuxiliaryTemplateFileName) {
        this.dropAuxiliaryTemplateFileName = dropAuxiliaryTemplateFileName;
    }

    @Override
    protected void doValidate() {
        if (this.classpathDir == null) {
            throw new RequiredPropertyNullRuntimeException("classpathDir");
        }
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    @Override
    protected void doInit() {
        this.dialect = this.getGenDialect(this.genDialectClassName);
        this.genDdlListener = ReflectUtil.newInstance(GenDdlListener.class, this.genDdlListenerClassName);
        if (this.transactional) {
            this.userTransaction = (UserTransaction)SingletonS2Container.getComponent(UserTransaction.class);
        }
        this.valueTypeProvider = this.createValueTypeProvider();
        this.ddlVersionDirectoryTree = this.createDdlVersionDirectoryTree();
        this.ddlVersionIncrementer = this.createDdlVersionIncrementer();
        this.tableModelFactory = this.createTableModelFactory();
        this.generator = this.createGenerator();
        this.entityMetaReader = this.createEntityMetaReader();
        this.databaseDescFactory = this.createDatabaseDescFactory();
        this.sqlUnitExecutor = this.createSqlUnitExecutor();
        this.dumper = this.createDumper();
        this.logRdbmsAndGenDialect(this.dialect);
    }

    @Override
    protected void doExecute() throws Throwable {
        this.ddlVersionIncrementer.increment(this.comment, new DdlVersionIncrementerCallback());
    }

    @Override
    protected void doDestroy() {
    }

    protected void generateDdl(DdlModel model, ManagedFile dir, String templateName) {
        GenerationContext context = this.createGenerationContext(model, dir, templateName);
        this.generator.generate(context);
    }

    protected GenerationContext createGenerationContext(DdlModel model, ManagedFile dir, String templateName) {
        String fileName = model.getCanonicalTableName() + ".sql";
        ManagedFile file = dir.createChild(fileName);
        file.createNewFile();
        return this.factory.createGenerationContext(this, model, file.asFile(), templateName, this.ddlFileEncoding, true);
    }

    protected EntityMetaReader createEntityMetaReader() {
        return this.factory.createEntityMetaReader(this, this.classpathDir, ClassUtil.concatName((String)this.rootPackageName, (String)this.entityPackageName), this.jdbcManager.getEntityMetaFactory(), this.entityClassNamePattern, this.ignoreEntityClassNamePattern, this.applyJavaCommentToDdl, this.javaFileSrcDirList, this.javaFileEncoding);
    }

    protected DatabaseDescFactory createDatabaseDescFactory() {
        return this.factory.createDatabaseDescFactory(this, this.jdbcManager.getEntityMetaFactory(), this.entityMetaReader, this.dialect, this.valueTypeProvider, this.autoGenerateForeignKey);
    }

    protected DdlVersionDirectoryTree createDdlVersionDirectoryTree() {
        return this.factory.createDdlVersionDirectoryTree(this, this.migrateDir, this.ddlInfoFile, this.versionNoPattern, this.env, false);
    }

    protected DdlVersionIncrementer createDdlVersionIncrementer() {
        List<String> createDirNameList = Arrays.asList(this.createTableDirName, this.createUniqueKeyDirName, this.createSequenceDirName, this.createForeignKeyDirName, this.dumpDirName, this.createAuxiliaryDirName);
        List<String> dropDirNameList = Arrays.asList(this.dropTableDirName, this.dropUniqueKeyDirName, this.dropSequenceDirName, this.dropForeignKeyDirName, this.dropAuxiliaryDirName);
        return this.factory.createDdlVersionIncrementer(this, this.ddlVersionDirectoryTree, this.genDdlListener, this.dialect, this.jdbcManager.getDataSource(), createDirNameList, dropDirNameList);
    }

    protected TableModelFactory createTableModelFactory() {
        return this.factory.createTableModelFactory(this, this.dialect, this.jdbcManager.getDataSource(), this.sqlIdentifierCaseType, this.sqlKeywordCaseType, this.statementDelimiter, this.tableOption, this.applyJavaCommentToDdl);
    }

    protected Dumper createDumper() {
        return this.factory.createDumper(this, this.dialect, this.dumpFileEncoding);
    }

    protected SqlUnitExecutor createSqlUnitExecutor() {
        return this.factory.createSqlUnitExecutor(this, this.jdbcManager.getDataSource(), this.userTransaction, true);
    }

    protected Generator createGenerator() {
        return this.factory.createGenerator(this, this.templateFileEncoding, this.templateFilePrimaryDir);
    }

    protected ValueTypeProvider createValueTypeProvider() {
        return this.factory.createValueTypeProvider(this, this.jdbcManager.getDialect());
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DdlVersionIncrementerCallback
    implements DdlVersionIncrementer.Callback {
        protected Map<String, ManagedFile> createDirChildMap = new HashMap<String, ManagedFile>(5);
        protected Map<String, ManagedFile> dropDirChildMap = new HashMap<String, ManagedFile>(5);
        protected ManagedFile createDir;
        protected ManagedFile dropDir;

        protected DdlVersionIncrementerCallback() {
        }

        @Override
        public void execute(DdlVersionDirectory versionDirectory) {
            this.createDir = versionDirectory.getCreateDirectory();
            this.dropDir = versionDirectory.getDropDirectory();
            final DatabaseDesc databaseDesc = GenerateDdlCommand.this.databaseDescFactory.getDatabaseDesc();
            for (TableDesc tableDesc : databaseDesc.getTableDescList()) {
                TableModel model = GenerateDdlCommand.this.tableModelFactory.getTableModel(tableDesc);
                this.generateTableDdl(model);
                this.generateUniqueKeyDdl(model);
                this.generateForeignKeyDdl(model);
                this.generateSequenceDdl(model);
                this.generateAuxiliaryDdl(model);
            }
            if (GenerateDdlCommand.this.dump) {
                GenerateDdlCommand.this.sqlUnitExecutor.execute(new SqlUnitExecutor.Callback(){

                    public void execute(SqlExecutionContext context) {
                        GenerateDdlCommand.this.dumper.dump(context, databaseDesc, new File(DdlVersionIncrementerCallback.this.createDir.asFile(), GenerateDdlCommand.this.dumpDirName));
                    }
                });
            }
            this.clear();
        }

        protected void generateTableDdl(TableModel model) {
            GenerateDdlCommand.this.generateDdl(model, this.getCreateDirChild(GenerateDdlCommand.this.createTableDirName), GenerateDdlCommand.this.createTableTemplateFileName);
            GenerateDdlCommand.this.generateDdl(model, this.getDropDirChild(GenerateDdlCommand.this.dropTableDirName), GenerateDdlCommand.this.dropTableTemplateFileName);
        }

        protected void generateUniqueKeyDdl(TableModel model) {
            if (model.getUniqueKeyModelList().isEmpty()) {
                return;
            }
            GenerateDdlCommand.this.generateDdl(model, this.getCreateDirChild(GenerateDdlCommand.this.createUniqueKeyDirName), GenerateDdlCommand.this.createUniqueKeyTemplateFileName);
            GenerateDdlCommand.this.generateDdl(model, this.getDropDirChild(GenerateDdlCommand.this.dropUniqueKeyDirName), GenerateDdlCommand.this.dropUniqueKeyTemplateFileName);
        }

        protected void generateForeignKeyDdl(TableModel model) {
            if (model.getForeignKeyModelList().isEmpty()) {
                return;
            }
            GenerateDdlCommand.this.generateDdl(model, this.getCreateDirChild(GenerateDdlCommand.this.createForeignKeyDirName), GenerateDdlCommand.this.createForeignKeyTemplateFileName);
            GenerateDdlCommand.this.generateDdl(model, this.getDropDirChild(GenerateDdlCommand.this.dropForeignKeyDirName), GenerateDdlCommand.this.dropForeignKeyTemplateFileName);
        }

        protected void generateSequenceDdl(TableModel model) {
            if (model.getSequenceModelList().isEmpty()) {
                return;
            }
            GenerateDdlCommand.this.generateDdl(model, this.getCreateDirChild(GenerateDdlCommand.this.createSequenceDirName), GenerateDdlCommand.this.createSequenceTemplateFileName);
            GenerateDdlCommand.this.generateDdl(model, this.getDropDirChild(GenerateDdlCommand.this.dropSequenceDirName), GenerateDdlCommand.this.dropSequenceTemplateFileName);
        }

        protected void generateAuxiliaryDdl(TableModel model) {
            GenerateDdlCommand.this.generateDdl(model, this.getCreateDirChild(GenerateDdlCommand.this.createAuxiliaryDirName), GenerateDdlCommand.this.createAuxiliaryTemplateFileName);
            GenerateDdlCommand.this.generateDdl(model, this.getDropDirChild(GenerateDdlCommand.this.dropAuxiliaryDirName), GenerateDdlCommand.this.dropAuxiliaryTemplateFileName);
        }

        protected ManagedFile getCreateDirChild(String childName) {
            ManagedFile child = this.createDirChildMap.get(childName);
            if (child != null) {
                return child;
            }
            child = this.createDir.createChild(childName);
            this.createDirChildMap.put(childName, child);
            return child;
        }

        protected ManagedFile getDropDirChild(String childName) {
            ManagedFile child = this.dropDirChildMap.get(childName);
            if (child != null) {
                return child;
            }
            child = this.dropDir.createChild(childName);
            this.dropDirChildMap.put(childName, child);
            return child;
        }

        protected void clear() {
            this.deleteDirIfEmpty(this.createDirChildMap.values());
            this.deleteDirIfEmpty(this.dropDirChildMap.values());
            this.createDirChildMap.clear();
            this.dropDirChildMap.clear();
        }

        protected void deleteDirIfEmpty(Collection<ManagedFile> dirs) {
            for (ManagedFile dir : dirs) {
                if (dir.hasChild()) continue;
                dir.delete();
            }
        }
    }
}

