/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalDestroyMethodAnnotationRuntimeException;
import org.seasar.framework.container.IllegalInitMethodAnnotationRuntimeException;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.AbstractAnnotationHandler;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

public class ConstantAnnotationHandler
extends AbstractAnnotationHandler {
    public ComponentDef createComponentDef(Class componentClass, InstanceDef defaultInstanceDef, AutoBindingDef defaultAutoBindingDef) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        if (!beanDesc.hasField("COMPONENT")) {
            return this.createComponentDefInternal(componentClass, defaultInstanceDef, defaultAutoBindingDef);
        }
        Field field = beanDesc.getField("COMPONENT");
        if (!this.isConstantAnnotationField(field)) {
            return this.createComponentDefInternal(componentClass, defaultInstanceDef, defaultAutoBindingDef);
        }
        String componentStr = (String)FieldUtil.get(field, null);
        String[] array = StringUtil.split(componentStr, "=, ");
        ComponentDef componentDef = this.createComponentDefInternal(componentClass, defaultInstanceDef, defaultAutoBindingDef);
        for (int i = 0; i < array.length; i += 2) {
            String key = array[i].trim();
            String value = array[i + 1].trim();
            if ("name".equalsIgnoreCase(key)) {
                componentDef.setComponentName(value);
                continue;
            }
            if ("instance".equalsIgnoreCase(key)) {
                componentDef.setInstanceDef(InstanceDefFactory.getInstanceDef(value));
                continue;
            }
            if ("autoBinding".equalsIgnoreCase(key)) {
                componentDef.setAutoBindingDef(AutoBindingDefFactory.getAutoBindingDef(value));
                continue;
            }
            throw new IllegalArgumentException(componentStr);
        }
        return componentDef;
    }

    protected boolean isConstantAnnotationField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public PropertyDef createPropertyDef(BeanDesc beanDesc, PropertyDesc propertyDesc) {
        String propName = propertyDesc.getPropertyName();
        String fieldName = propName + "_BINDING";
        if (!beanDesc.hasField(fieldName)) {
            return null;
        }
        String bindingStr = (String)beanDesc.getFieldValue(fieldName, null);
        String bindingTypeName = null;
        String expression = null;
        if (bindingStr != null) {
            String[] array = StringUtil.split(bindingStr, "=, ");
            if (array.length == 1) {
                expression = array[0];
            } else {
                for (int i = 0; i < array.length; i += 2) {
                    String key = array[i].trim();
                    String value = array[i + 1].trim();
                    if ("bindingType".equalsIgnoreCase(key)) {
                        bindingTypeName = value;
                        continue;
                    }
                    if ("value".equalsIgnoreCase(key)) {
                        expression = value;
                        continue;
                    }
                    throw new IllegalArgumentException(bindingStr);
                }
            }
        }
        return this.createPropertyDef(propName, expression, bindingTypeName);
    }

    public void appendAspect(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        if (!beanDesc.hasField("ASPECT")) {
            return;
        }
        String aspectStr = (String)beanDesc.getFieldValue("ASPECT", null);
        String[] array = StringUtil.split(aspectStr, "=, ");
        String interceptor = null;
        String pointcut = null;
        if (array.length == 1) {
            interceptor = array[0];
        } else {
            for (int i = 0; i < array.length; i += 2) {
                String key = array[i].trim();
                String value = array[i + 1].trim();
                if ("value".equalsIgnoreCase(key)) {
                    interceptor = value;
                    continue;
                }
                if ("pointcut".equalsIgnoreCase(key)) {
                    pointcut = value;
                    continue;
                }
                throw new IllegalArgumentException(aspectStr);
            }
        }
        this.appendAspect(componentDef, interceptor, pointcut);
    }

    protected void appendAspect(ComponentDef componentDef, String interceptor, String pointcut) {
        if (interceptor == null) {
            throw new EmptyRuntimeException("interceptor");
        }
        AspectDef aspectDef = AspectDefFactory.createAspectDef(interceptor, pointcut);
        componentDef.addAspectDef(aspectDef);
    }

    protected void appendAspect(ComponentDef componentDef, String interceptor, Method pointcut) {
        if (interceptor == null) {
            throw new EmptyRuntimeException("interceptor");
        }
        AspectDef aspectDef = AspectDefFactory.createAspectDef(interceptor, pointcut);
        componentDef.addAspectDef(aspectDef);
    }

    public void appendInitMethod(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        if (!beanDesc.hasField("INIT_METHOD")) {
            return;
        }
        String initMethodStr = (String)beanDesc.getFieldValue("INIT_METHOD", null);
        if (StringUtil.isEmpty(initMethodStr)) {
            return;
        }
        String[] array = StringUtil.split(initMethodStr, ", ");
        for (int i = 0; i < array.length; ++i) {
            String methodName = array[i].trim();
            if (!beanDesc.hasMethod(methodName)) {
                throw new IllegalInitMethodAnnotationRuntimeException(componentClass, methodName);
            }
            Method[] methods = beanDesc.getMethods(methodName);
            if (methods.length != 1 || methods[0].getParameterTypes().length != 0) {
                throw new IllegalInitMethodAnnotationRuntimeException(componentClass, methodName);
            }
            if (!this.isInitMethodRegisterable(componentDef, methodName)) continue;
            this.appendInitMethod(componentDef, methodName);
        }
    }

    protected void appendInitMethod(ComponentDef componentDef, String methodName) {
        InitMethodDefImpl initMethodDef = new InitMethodDefImpl(methodName);
        componentDef.addInitMethodDef(initMethodDef);
    }

    public void appendDestroyMethod(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        if (componentClass == null) {
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        if (!beanDesc.hasField("DESTROY_METHOD")) {
            return;
        }
        String destroyMethodStr = (String)beanDesc.getFieldValue("DESTROY_METHOD", null);
        if (StringUtil.isEmpty(destroyMethodStr)) {
            return;
        }
        String[] array = StringUtil.split(destroyMethodStr, ", ");
        for (int i = 0; i < array.length; ++i) {
            String methodName = array[i].trim();
            if (!beanDesc.hasMethod(methodName)) {
                throw new IllegalDestroyMethodAnnotationRuntimeException(componentClass, methodName);
            }
            Method[] methods = beanDesc.getMethods(methodName);
            if (methods.length != 1 || methods[0].getParameterTypes().length != 0) {
                throw new IllegalDestroyMethodAnnotationRuntimeException(componentClass, methodName);
            }
            if (!this.isDestroyMethodRegisterable(componentDef, methodName)) continue;
            this.appendDestroyMethod(componentDef, methodName);
        }
    }

    protected void appendDestroyMethod(ComponentDef componentDef, Method method) {
        DestroyMethodDefImpl destroyMethodDef = new DestroyMethodDefImpl(method);
        componentDef.addDestroyMethodDef(destroyMethodDef);
    }

    protected void appendDestroyMethod(ComponentDef componentDef, String methodName) {
        DestroyMethodDefImpl destroyMethodDef = new DestroyMethodDefImpl(methodName);
        componentDef.addDestroyMethodDef(destroyMethodDef);
    }
}

