/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.framework.util.InputStreamUtil;

public class BinaryStreamType
extends AbstractValueType {
    public BinaryStreamType() {
        super(-2);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getBinaryStream(index);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getBinaryStream(columnName);
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toBinaryStream(cs.getBytes(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toBinaryStream(cs.getBytes(parameterName));
    }

    private InputStream toBinaryStream(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            ps.setBinaryStream(index, is, InputStreamUtil.available((InputStream)is));
        } else {
            ps.setObject(index, value);
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else if (value instanceof InputStream) {
            InputStream is = (InputStream)value;
            cs.setBinaryStream(parameterName, is, InputStreamUtil.available((InputStream)is));
        } else {
            cs.setObject(parameterName, value);
        }
    }
}

