/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.StringConversionUtil;

public class StringClobType
extends AbstractValueType {
    public StringClobType() {
        super(2005);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return this.convertToString(resultSet.getCharacterStream(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return this.convertToString(resultSet.getCharacterStream(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.convertToString(cs.getClob(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.convertToString(cs.getClob(parameterName));
    }

    private String convertToString(Reader reader) throws SQLException {
        if (reader == null) {
            return null;
        }
        return ReaderUtil.readText((Reader)reader);
    }

    private String convertToString(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        return this.convertToString(clob.getCharacterStream());
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            String s = StringConversionUtil.toString((Object)value);
            ps.setCharacterStream(index, (Reader)new StringReader(s), s.length());
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            String s = StringConversionUtil.toString((Object)value);
            cs.setCharacterStream(parameterName, (Reader)new StringReader(s), s.length());
        }
    }
}

