/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import junit.framework.TestCase;
import org.seasar.doma.jdbc.GreedyCacheSqlFileRepository;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.OracleDialect;
import org.seasar.doma.jdbc.dialect.PostgresDialect;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class GreedyCacheSqlFileRepositoryTest
extends TestCase {
    public void testGetSqlFile() throws Exception {
        StandardDialect dialect = new StandardDialect();
        String path = "META-INF/" + ((Object)((Object)this)).getClass().getName().replace(".", "/") + ".sql";
        GreedyCacheSqlFileRepository repository = new GreedyCacheSqlFileRepository();
        SqlFile sqlFile = repository.getSqlFile(path, (Dialect)dialect);
        GreedyCacheSqlFileRepositoryTest.assertNotNull((Object)sqlFile);
        SqlFile sqlFile2 = repository.getSqlFile(path, (Dialect)dialect);
        GreedyCacheSqlFileRepositoryTest.assertSame((Object)sqlFile, (Object)sqlFile2);
        GreedyCacheSqlFileRepositoryTest.assertEquals((String)path, (String)sqlFile.getPath());
    }

    public void testGetSqlFile_oracle() throws Exception {
        OracleDialect dialect = new OracleDialect();
        String path = "META-INF/" + ((Object)((Object)this)).getClass().getName().replace(".", "/") + ".sql";
        GreedyCacheSqlFileRepository repository = new GreedyCacheSqlFileRepository();
        SqlFile sqlFile = repository.getSqlFile(path, (Dialect)dialect);
        GreedyCacheSqlFileRepositoryTest.assertEquals((String)("META-INF/" + ((Object)((Object)this)).getClass().getName().replace(".", "/") + "-oracle.sql"), (String)sqlFile.getPath());
    }

    public void testGetSqlFile_postgres() throws Exception {
        PostgresDialect dialect = new PostgresDialect();
        String path = "META-INF/" + ((Object)((Object)this)).getClass().getName().replace(".", "/") + ".sql";
        GreedyCacheSqlFileRepository repository = new GreedyCacheSqlFileRepository();
        SqlFile sqlFile = repository.getSqlFile(path, (Dialect)dialect);
        GreedyCacheSqlFileRepositoryTest.assertEquals((String)path, (String)sqlFile.getPath());
    }
}

