/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.internal.jdbc.sql.node.AnonymousNode;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseNode;
import org.seasar.doma.internal.jdbc.sql.node.EndNode;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.IfBlockNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.internal.jdbc.sql.node.LogicalOperatorNode;
import org.seasar.doma.internal.jdbc.sql.node.OtherNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.jdbc.sql.node.WhereClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.WhitespaceNode;
import org.seasar.doma.internal.jdbc.sql.node.WordNode;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;

public class NodePreparedSqlBuilderTest
extends TestCase {
    private final SqlLocation location = new SqlLocation("dummy sql", 0, 0);
    private final MockConfig config = new MockConfig();

    public void testBindVariableNode() throws Exception {
        SelectClauseNode select = new SelectClauseNode("select");
        select.addNode((SqlNode)OtherNode.of((String)" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        from.addNode((SqlNode)new WordNode("aaa"));
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        WhereClauseNode where = new WhereClauseNode("where");
        where.addNode((SqlNode)WhitespaceNode.of((String)" "));
        where.addNode((SqlNode)new WordNode("bbb"));
        where.addNode((SqlNode)OtherNode.of((String)" = "));
        BindVariableNode variable1 = new BindVariableNode(this.location, "name", "/*#name*/");
        variable1.setWordNode(new WordNode("'hoge'"));
        where.addNode((SqlNode)variable1);
        where.addNode((SqlNode)WhitespaceNode.of((String)" "));
        where.addNode((SqlNode)new LogicalOperatorNode("and"));
        where.addNode((SqlNode)WhitespaceNode.of((String)" "));
        where.addNode((SqlNode)new WordNode("ccc"));
        where.addNode((SqlNode)OtherNode.of((String)" = "));
        BindVariableNode variable2 = new BindVariableNode(this.location, "salary", "/*#salary*/");
        variable2.setWordNode(new WordNode("100"));
        where.addNode((SqlNode)variable2);
        SelectStatementNode statement = new SelectStatementNode();
        statement.setSelectClauseNode(select);
        statement.setFromClauseNode(from);
        statement.setWhereClauseNode(where);
        AnonymousNode root = new AnonymousNode();
        root.addNode((SqlNode)statement);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(100)));
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        PreparedSql sql = builder.build((SqlNode)root);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa where bbb = ? and ccc = ?", (String)sql.getRawSql());
        NodePreparedSqlBuilderTest.assertEquals((int)2, (int)sql.getParameters().size());
        NodePreparedSqlBuilderTest.assertEquals((Object)"hoge", (Object)((PreparedSqlParameter)sql.getParameters().get(0)).getWrapper().get());
        NodePreparedSqlBuilderTest.assertEquals((Object)new BigDecimal(100), (Object)((PreparedSqlParameter)sql.getParameters().get(1)).getWrapper().get());
    }

    public void testIfNode_true() throws Exception {
        SelectClauseNode select = new SelectClauseNode("select");
        select.addNode((SqlNode)OtherNode.of((String)" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        from.addNode((SqlNode)new WordNode("aaa"));
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        WhereClauseNode where = new WhereClauseNode("where");
        where.addNode((SqlNode)WhitespaceNode.of((String)" "));
        IfNode ifNode = new IfNode(this.location, "true", "/*if true*/");
        ifNode.addNode((SqlNode)new WordNode("bbb"));
        ifNode.addNode((SqlNode)OtherNode.of((String)" = "));
        ifNode.addNode((SqlNode)new WordNode("ccc"));
        IfBlockNode ifBlockNode = new IfBlockNode();
        ifBlockNode.setIfNode(ifNode);
        ifBlockNode.setEndNode(new EndNode("/*end*/"));
        where.addNode((SqlNode)ifBlockNode);
        SelectStatementNode statement = new SelectStatementNode();
        statement.setSelectClauseNode(select);
        statement.setFromClauseNode(from);
        statement.setWhereClauseNode(where);
        AnonymousNode root = new AnonymousNode();
        root.addNode((SqlNode)statement);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        PreparedSql sql = builder.build((SqlNode)statement);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa where bbb = ccc", (String)sql.getRawSql());
    }

    public void testIfNode_false() throws Exception {
        SelectClauseNode select = new SelectClauseNode("select");
        select.addNode((SqlNode)OtherNode.of((String)" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        from.addNode((SqlNode)new WordNode("aaa"));
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        WhereClauseNode where = new WhereClauseNode("where");
        where.addNode((SqlNode)WhitespaceNode.of((String)" "));
        IfNode ifNode = new IfNode(this.location, "false", "/*if false*/");
        ifNode.addNode((SqlNode)new WordNode("bbb"));
        ifNode.addNode((SqlNode)OtherNode.of((String)" = "));
        ifNode.addNode((SqlNode)new WordNode("ccc"));
        IfBlockNode ifBlockNode = new IfBlockNode();
        ifBlockNode.setIfNode(ifNode);
        ifBlockNode.setEndNode(new EndNode("/*end*/"));
        where.addNode((SqlNode)ifBlockNode);
        SelectStatementNode statement = new SelectStatementNode();
        statement.setSelectClauseNode(select);
        statement.setFromClauseNode(from);
        statement.setWhereClauseNode(where);
        AnonymousNode root = new AnonymousNode();
        root.addNode((SqlNode)statement);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        PreparedSql sql = builder.build((SqlNode)statement);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa", (String)sql.getRawSql());
    }

    public void testElseNode() throws Exception {
        SelectClauseNode select = new SelectClauseNode("select");
        select.addNode((SqlNode)OtherNode.of((String)" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        from.addNode((SqlNode)new WordNode("aaa"));
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        WhereClauseNode where = new WhereClauseNode("where");
        where.addNode((SqlNode)WhitespaceNode.of((String)" "));
        IfNode ifNode = new IfNode(this.location, "false", "/*if false*/");
        ifNode.addNode((SqlNode)new WordNode("bbb"));
        ifNode.addNode((SqlNode)OtherNode.of((String)" = "));
        ifNode.addNode((SqlNode)new WordNode("ccc"));
        ElseNode elseNode = new ElseNode("/*else*/");
        elseNode.addNode((SqlNode)new WordNode("ddd"));
        elseNode.addNode((SqlNode)OtherNode.of((String)" = "));
        elseNode.addNode((SqlNode)new WordNode("eee"));
        EndNode endNode = new EndNode("/*end*/");
        IfBlockNode ifBlock = new IfBlockNode();
        ifBlock.setIfNode(ifNode);
        ifBlock.setElseNode(elseNode);
        ifBlock.setEndNode(endNode);
        where.addNode((SqlNode)ifBlock);
        SelectStatementNode statement = new SelectStatementNode();
        statement.setSelectClauseNode(select);
        statement.setFromClauseNode(from);
        statement.setWhereClauseNode(where);
        AnonymousNode root = new AnonymousNode();
        root.addNode((SqlNode)statement);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        PreparedSql sql = builder.build((SqlNode)statement);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa where ddd = eee", (String)sql.getRawSql());
    }

    public void testWhere() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        String testSql = "select * from aaa where /*%if false*/ename = 'aaa'/*%end */";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa", (String)sql.getRawSql());
    }

    public void testWhere_embeddedVariable() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("embedded", new Value(String.class, (Object)"bbb = ccc"));
        String testSql = "select * from aaa where /*%if false*/ename = 'aaa'/*%end */ /*#embedded*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa where  bbb = ccc", (String)sql.getRawSql());
    }

    public void testWhere_embeddedVariable_orderBy() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("embedded", new Value(String.class, (Object)"order by bbb"));
        String testSql = "select * from aaa where /*%if false*/ename = 'aaa'/*%end */ /*#embedded*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa   order by bbb", (String)sql.getRawSql());
    }

    public void testWhere_embeddedVariable_orderBy_followedByForUpdate() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("embedded", new Value(String.class, (Object)"order by bbb"));
        String testSql = "select * from aaa where /*%if false*/ename = 'aaa'/*%end */ /*#embedded*/ for update";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        PreparedSql sql = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa   order by bbb for update", (String)sql.getRawSql());
    }

    public void testAndNode() throws Exception {
        SelectClauseNode select = new SelectClauseNode("select");
        select.addNode((SqlNode)OtherNode.of((String)" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        from.addNode((SqlNode)new WordNode("aaa"));
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        WhereClauseNode where = new WhereClauseNode("where");
        IfNode ifNode1 = new IfNode(this.location, "true", "/*if true*/");
        ifNode1.addNode((SqlNode)WhitespaceNode.of((String)" "));
        ifNode1.addNode((SqlNode)new WordNode("bbb"));
        ifNode1.addNode((SqlNode)OtherNode.of((String)" = "));
        ifNode1.addNode((SqlNode)new WordNode("ccc"));
        EndNode endNode1 = new EndNode("/*end*/");
        IfBlockNode ifBlock1 = new IfBlockNode();
        ifBlock1.setIfNode(ifNode1);
        ifBlock1.setEndNode(endNode1);
        where.addNode((SqlNode)ifBlock1);
        IfNode ifNode2 = new IfNode(this.location, "true", "/*if true*/");
        ifNode2.addNode((SqlNode)WhitespaceNode.of((String)" "));
        LogicalOperatorNode and = new LogicalOperatorNode("and");
        ifNode2.addNode((SqlNode)and);
        and.addNode((SqlNode)WhitespaceNode.of((String)" "));
        and.addNode((SqlNode)new WordNode("ddd"));
        and.addNode((SqlNode)OtherNode.of((String)" = "));
        and.addNode((SqlNode)new WordNode("eee"));
        EndNode endNode2 = new EndNode("/*end*/");
        IfBlockNode ifBlock2 = new IfBlockNode();
        ifBlock2.setIfNode(ifNode2);
        ifBlock2.setEndNode(endNode2);
        where.addNode((SqlNode)ifBlock2);
        SelectStatementNode statement = new SelectStatementNode();
        statement.setSelectClauseNode(select);
        statement.setFromClauseNode(from);
        statement.setWhereClauseNode(where);
        AnonymousNode root = new AnonymousNode();
        root.addNode((SqlNode)statement);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        PreparedSql sql = builder.build((SqlNode)statement);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa where bbb = ccc and ddd = eee", (String)sql.getRawSql());
    }

    public void testAndNode_remove() throws Exception {
        SelectClauseNode select = new SelectClauseNode("select");
        select.addNode((SqlNode)OtherNode.of((String)" * "));
        FromClauseNode from = new FromClauseNode("from");
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        from.addNode((SqlNode)new WordNode("aaa"));
        from.addNode((SqlNode)WhitespaceNode.of((String)" "));
        WhereClauseNode where = new WhereClauseNode("where");
        IfNode ifNode1 = new IfNode(this.location, "false", "/*if false*/");
        ifNode1.addNode((SqlNode)WhitespaceNode.of((String)" "));
        ifNode1.addNode((SqlNode)new WordNode("bbb"));
        ifNode1.addNode((SqlNode)OtherNode.of((String)" = "));
        ifNode1.addNode((SqlNode)new WordNode("ccc"));
        EndNode endNode1 = new EndNode("/*end*/");
        IfBlockNode ifBlock1 = new IfBlockNode();
        ifBlock1.setIfNode(ifNode1);
        ifBlock1.setEndNode(endNode1);
        where.addNode((SqlNode)ifBlock1);
        IfNode ifNode2 = new IfNode(this.location, "true", "/*if true*/");
        ifNode2.addNode((SqlNode)WhitespaceNode.of((String)" "));
        LogicalOperatorNode and = new LogicalOperatorNode("and");
        ifNode2.addNode((SqlNode)and);
        and.addNode((SqlNode)WhitespaceNode.of((String)" "));
        and.addNode((SqlNode)new WordNode("ddd"));
        and.addNode((SqlNode)OtherNode.of((String)" = "));
        and.addNode((SqlNode)new WordNode("eee"));
        EndNode endNode2 = new EndNode("/*end*/");
        IfBlockNode ifBlock2 = new IfBlockNode();
        ifBlock2.setIfNode(ifNode2);
        ifBlock2.setEndNode(endNode2);
        where.addNode((SqlNode)ifBlock2);
        SelectStatementNode statement = new SelectStatementNode();
        statement.setSelectClauseNode(select);
        statement.setFromClauseNode(from);
        statement.setWhereClauseNode(where);
        AnonymousNode root = new AnonymousNode();
        root.addNode((SqlNode)statement);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        NodePreparedSqlBuilder builder = new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator);
        PreparedSql sql = builder.build((SqlNode)statement);
        NodePreparedSqlBuilderTest.assertEquals((String)"select * from aaa where  ddd = eee", (String)sql.getRawSql());
    }

    public void testEmbeddedVariable_containsSingleQuote() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        evaluator.add("orderBy", new Value(String.class, (Object)"aaa'"));
        String testSql = "select * from aaa where ename = /*name*/'aaa' and sal = /*salary*/-2000 /*#orderBy*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        try {
            new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
            NodePreparedSqlBuilderTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            NodePreparedSqlBuilderTest.assertEquals((Object)Message.DOMA2116, (Object)expected.getMessageResource());
        }
    }

    public void testEmbeddedVariable_containsSemicolon() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        evaluator.add("orderBy", new Value(String.class, (Object)"aaa;bbb"));
        String testSql = "select * from aaa where ename = /*name*/'aaa' and sal = /*salary*/-2000 /*#orderBy*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        try {
            new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
            NodePreparedSqlBuilderTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            NodePreparedSqlBuilderTest.assertEquals((Object)Message.DOMA2117, (Object)expected.getMessageResource());
        }
    }

    public void testEmbeddedVariable_lineComment() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        evaluator.add("orderBy", new Value(String.class, (Object)"aaa--bbb"));
        String testSql = "select * from aaa where ename = /*name*/'aaa' and sal = /*salary*/-2000 /*#orderBy*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        try {
            new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
            NodePreparedSqlBuilderTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            NodePreparedSqlBuilderTest.assertEquals((Object)Message.DOMA2122, (Object)expected.getMessageResource());
        }
    }

    public void testEmbeddedVariable_blockComment() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.add("name", new Value(String.class, (Object)"hoge"));
        evaluator.add("salary", new Value(BigDecimal.class, (Object)new BigDecimal(10000)));
        evaluator.add("orderBy", new Value(String.class, (Object)"aaa/*bbb"));
        String testSql = "select * from aaa where ename = /*name*/'aaa' and sal = /*salary*/-2000 /*#orderBy*/";
        SqlParser parser = new SqlParser(testSql);
        SqlNode sqlNode = parser.parse();
        try {
            new NodePreparedSqlBuilder((Config)this.config, SqlKind.SELECT, "dummyPath", evaluator).build(sqlNode);
            NodePreparedSqlBuilderTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            NodePreparedSqlBuilderTest.assertEquals((Object)Message.DOMA2123, (Object)expected.getMessageResource());
        }
    }
}

