/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.mock;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.seasar.doma.internal.jdbc.mock.MockCallableStatement;
import org.seasar.doma.internal.jdbc.mock.MockPreparedStatement;
import org.seasar.doma.internal.jdbc.mock.MockStatement;
import org.seasar.doma.internal.jdbc.mock.MockWrapper;
import org.seasar.doma.internal.util.AssertionUtil;

public class MockConnection
extends MockWrapper
implements Connection {
    public MockStatement statement = new MockStatement();
    public MockPreparedStatement preparedStatement = new MockPreparedStatement();
    public MockCallableStatement callableStatement = new MockCallableStatement();
    public boolean closed;
    public boolean committed;
    public boolean rolledback;
    public boolean autoCommit = true;
    public List<String> savepointNames = new ArrayList<String>();
    public int isolationLevel = 2;

    public MockConnection() {
    }

    public MockConnection(MockPreparedStatement preparedStatement) {
        this.preparedStatement = preparedStatement;
    }

    public MockConnection(MockCallableStatement callableStatement) {
        this.callableStatement = callableStatement;
        this.preparedStatement = callableStatement;
    }

    @Override
    public void clearWarnings() throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public void commit() throws SQLException {
        this.committed = true;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        AssertionUtil.notYetImplemented();
        return 0;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        AssertionUtil.notYetImplemented();
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        AssertionUtil.notYetImplemented();
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.callableStatement.sql = sql;
        return this.callableStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.callableStatement.sql = sql;
        return this.callableStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        AssertionUtil.assertTrue((!this.closed ? 1 : 0) != 0, (Object[])new Object[0]);
        this.preparedStatement.sql = sql;
        return this.preparedStatement;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String savepointName = savepoint.getSavepointName();
        int pos = this.savepointNames.lastIndexOf(savepointName);
        if (pos == -1) {
            throw new SQLException();
        }
        this.savepointNames.subList(0, pos + 1).clear();
    }

    @Override
    public void rollback() throws SQLException {
        this.rolledback = true;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String name = savepoint.getSavepointName();
        this.savepointNames.remove(name);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public Savepoint setSavepoint(final String name) throws SQLException {
        this.savepointNames.add(name);
        return new Savepoint(){

            @Override
            public String getSavepointName() throws SQLException {
                return name;
            }

            @Override
            public int getSavepointId() throws SQLException {
                throw new SQLException();
            }
        };
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.isolationLevel = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public String getSchema() throws SQLException {
        AssertionUtil.notYetImplemented();
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        AssertionUtil.notYetImplemented();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        AssertionUtil.notYetImplemented();
        return 0;
    }
}

