/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.BasicIterationHandler;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileSelectQuery;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.NonSingleColumnException;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class BasicIterationHandlerTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testHandle() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("aaa"));
        resultSet.rows.add(new RowData("bbb"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        BasicIterationHandler handler = new BasicIterationHandler((Wrapper)new StringWrapper(), (IterationCallback)new IterationCallback<String, String>(){
            private String result = "";

            public String iterate(String target, IterationContext iterationContext) {
                this.result = this.result + target;
                return this.result;
            }
        });
        String result = (String)handler.handle((ResultSet)resultSet, (SelectQuery)query);
        BasicIterationHandlerTest.assertEquals((String)"aaabbb", (String)result);
    }

    public void testHandle_exits() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("aaa"));
        resultSet.rows.add(new RowData("bbb"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        BasicIterationHandler handler = new BasicIterationHandler((Wrapper)new StringWrapper(), (IterationCallback)new IterationCallback<String, String>(){
            private String result = "";

            public String iterate(String target, IterationContext iterationContext) {
                this.result = this.result + target;
                iterationContext.exit();
                return this.result;
            }
        });
        String result = (String)handler.handle((ResultSet)resultSet, (SelectQuery)query);
        BasicIterationHandlerTest.assertEquals((String)"aaa", (String)result);
    }

    public void testHandle_NonSingleColumnException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("name"));
        metaData.columns.add(new ColumnMetaData("age"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("hoge", 10));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setResultEnsured(true);
        query.prepare();
        BasicIterationHandler handler = new BasicIterationHandler((Wrapper)new StringWrapper(), (IterationCallback)new IterationCallback<String, String>(){
            private String result = "";

            public String iterate(String target, IterationContext iterationContext) {
                this.result = this.result + target;
                return this.result;
            }
        });
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            BasicIterationHandlerTest.fail();
        }
        catch (NonSingleColumnException nonSingleColumnException) {
            // empty catch block
        }
    }

    public void testHandle_NoResultException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setResultEnsured(true);
        query.prepare();
        BasicIterationHandler handler = new BasicIterationHandler((Wrapper)new StringWrapper(), (IterationCallback)new IterationCallback<String, String>(){
            private String result = "";

            public String iterate(String target, IterationContext iterationContext) {
                this.result = this.result + target;
                return this.result;
            }
        });
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            BasicIterationHandlerTest.fail();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }
}

