/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr;

import junit.framework.TestCase;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionTokenType;
import org.seasar.doma.internal.expr.ExpressionTokenizer;
import org.seasar.doma.message.Message;

public class ExpressionTokenizerTest
extends TestCase {
    public void testVariableOperand() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("name");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"name", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testStringLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("\"aaa bbb\"");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.STRING_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"\"aaa bbb\"", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testIntLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("+13");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.INT_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"+13", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testLongLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("+13L");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.LONG_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"+13L", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testFloatLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("+13F");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.FLOAT_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"+13F", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testDoubleLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("+13D");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.DOUBLE_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"+13D", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBigDecimalLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("+13B");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.BIGDECIMAL_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"+13B", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testNullLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("null");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.NULL_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"null", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testTrueLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("true");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.TRUE_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"true", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testFalseLiteral() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("false");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.FALSE_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"false", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testExpression() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("manager.eq(true) && name.eq(\"aaa\")");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"manager", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.METHOD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)".eq", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.OPENED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"(", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.TRUE_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"true", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.CLOSED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)")", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.WHITESPACE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.AND_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"&&", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.WHITESPACE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"name", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.METHOD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)".eq", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.OPENED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"(", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.STRING_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"\"aaa\"", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.CLOSED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)")", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testGetPosition() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("aaa bbb ccc");
        ExpressionTokenizerTest.assertEquals((int)0, (int)tokenizer.getPosition());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((int)3, (int)tokenizer.getPosition());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.WHITESPACE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((int)4, (int)tokenizer.getPosition());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((int)7, (int)tokenizer.getPosition());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.WHITESPACE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((int)8, (int)tokenizer.getPosition());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"ccc", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((int)11, (int)tokenizer.getPosition());
    }

    public void testFieldOperator() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("aaa.bbb");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.FIELD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)".bbb", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testFieldOperator_identifierNotFound() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("aaa.");
        try {
            tokenizer.next();
            ExpressionTokenizerTest.fail();
        }
        catch (ExpressionException expected) {
            System.out.println(expected.getMessage());
            ExpressionTokenizerTest.assertEquals((Object)Message.DOMA3021, (Object)expected.getMessageResource());
        }
    }

    public void testFieldOperator_illegalJavaIdentifierStart() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("aaa.!");
        try {
            tokenizer.next();
            ExpressionTokenizerTest.fail();
        }
        catch (ExpressionException expected) {
            System.out.println(expected.getMessage());
            ExpressionTokenizerTest.assertEquals((Object)Message.DOMA3022, (Object)expected.getMessageResource());
        }
    }

    public void testMethodOperator() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("aaa.bbb(\"ccc\")");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.METHOD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)".bbb", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.OPENED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"(", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.STRING_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"\"ccc\"", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.CLOSED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)")", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.EOE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testParans() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("aaa.bbb(2, 3)");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.METHOD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)".bbb", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.OPENED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"(", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.INT_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"2", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.COMMA_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)",", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.WHITESPACE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.INT_LITERAL, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"3", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.CLOSED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)")", (String)tokenizer.getToken());
    }

    public void testFunctionOperator() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("@startWith(aaa)");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.FUNCTION_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"@startWith", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.OPENED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"(", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.CLOSED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)")", (String)tokenizer.getToken());
    }

    public void testBuiltinFunctionOperator_nameNotFound() throws Exception {
        try {
            new ExpressionTokenizer("@");
            ExpressionTokenizerTest.fail();
        }
        catch (ExpressionException expected) {
            System.out.println(expected.getMessage());
            ExpressionTokenizerTest.assertEquals((Object)Message.DOMA3023, (Object)expected.getMessageResource());
        }
    }

    public void testBuiltinFunctionOperator_illegalJavaIdentifierStart() throws Exception {
        try {
            new ExpressionTokenizer("@!");
            ExpressionTokenizerTest.fail();
        }
        catch (ExpressionException expected) {
            System.out.println(expected.getMessage());
            ExpressionTokenizerTest.assertEquals((Object)Message.DOMA3024, (Object)expected.getMessageResource());
        }
    }

    public void testStaticMethodOperator() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("@java.lang.String@valueOf(aaa)");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.STATIC_METHOD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"@java.lang.String@valueOf", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.OPENED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"(", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.CLOSED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)")", (String)tokenizer.getToken());
    }

    public void testStaticMethodOperator_simpleClassName() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("@Aaa@valueOf(aaa)");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.STATIC_METHOD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"@Aaa@valueOf", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.OPENED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"(", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.VARIABLE, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.CLOSED_PARENS, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)")", (String)tokenizer.getToken());
    }

    public void testStaticFieldOperator() throws Exception {
        ExpressionTokenizer tokenizer = new ExpressionTokenizer("@java.lang.String@CASE_INSENSITIVE_ORDER ");
        ExpressionTokenizerTest.assertEquals((Object)ExpressionTokenType.STATIC_FIELD_OPERATOR, (Object)tokenizer.next());
        ExpressionTokenizerTest.assertEquals((String)"@java.lang.String@CASE_INSENSITIVE_ORDER", (String)tokenizer.getToken());
    }
}

