/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.NonUniqueResultException;

public class MapSingleResultHandler
implements ResultSetHandler<Map<String, Object>> {
    private final MapKeyNamingType mapKeyNamingType;

    public MapSingleResultHandler(MapKeyNamingType mapKeyNamingType) {
        AssertionUtil.assertNotNull((Object)mapKeyNamingType);
        this.mapKeyNamingType = mapKeyNamingType;
    }

    @Override
    public Map<String, Object> handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        AssertionUtil.assertNotNull((Object)resultSet, (Object)query);
        MapFetcher fetcher = new MapFetcher(query, this.mapKeyNamingType);
        if (resultSet.next()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            fetcher.fetch(resultSet, (Map<String, Object>)map);
            if (resultSet.next()) {
                PreparedSql sql = query.getSql();
                throw new NonUniqueResultException(query.getConfig().getExceptionSqlLogType(), sql);
            }
            return map;
        }
        if (query.isResultEnsured()) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(query.getConfig().getExceptionSqlLogType(), sql);
        }
        return null;
    }
}

