/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.doma.internal.jdbc.command.BasicFetcher;
import org.seasar.doma.internal.jdbc.command.EntityBuilder;
import org.seasar.doma.internal.jdbc.command.GetOutParameterFunction;
import org.seasar.doma.internal.jdbc.command.MapFetcher;
import org.seasar.doma.internal.jdbc.command.ResultFetcher;
import org.seasar.doma.internal.jdbc.query.ModuleQuery;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListResultParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultParameter;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameter;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.DomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListResultParameter;
import org.seasar.doma.internal.jdbc.sql.DomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainResultParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListResultParameter;
import org.seasar.doma.internal.jdbc.sql.MapListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListResultParameter;
import org.seasar.doma.internal.jdbc.sql.OutParameter;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.domain.DomainWrapper;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;
import org.seasar.doma.wrapper.Wrapper;

public class CallableSqlParameterFetcher
implements ResultFetcher<CallableStatement, List<? extends CallableSqlParameter>> {
    protected final ModuleQuery query;

    public CallableSqlParameterFetcher(ModuleQuery query) throws SQLException {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    @Override
    public void fetch(CallableStatement callableStatement, List<? extends CallableSqlParameter> parameters) throws SQLException {
        AssertionUtil.assertNotNull((Object)callableStatement, parameters);
        FetchingVisitor fetchngVisitor = new FetchingVisitor(this.query, callableStatement);
        for (CallableSqlParameter callableSqlParameter : parameters) {
            callableSqlParameter.accept(fetchngVisitor, null);
        }
    }

    protected static class FetchingVisitor
    implements CallableSqlParameterVisitor<Void, Void, SQLException> {
        protected final ModuleQuery query;
        protected final Dialect dialect;
        protected final JdbcMappingVisitor jdbcMappingVisitor;
        protected final CallableStatement callableStatement;
        protected int index = 1;

        public FetchingVisitor(ModuleQuery query, CallableStatement callableStatement) {
            this.query = query;
            this.dialect = query.getConfig().getDialect();
            this.jdbcMappingVisitor = this.dialect.getJdbcMappingVisitor();
            this.callableStatement = callableStatement;
        }

        @Override
        public <V> Void visitBasicInOutParameter(BasicInOutParameter<V> parameter, Void p) throws SQLException {
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainInOutParameter(DomainInOutParameter<V, D> parameter, Void p) throws SQLException {
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public Void visitBasicInParameter(BasicInParameter parameter, Void p) throws SQLException {
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainInParameter(DomainInParameter<V, D> parameter, Void p) throws SQLException {
            ++this.index;
            return null;
        }

        @Override
        public <V> Void visitBasicOutParameter(BasicOutParameter<V> parameter, Void p) throws SQLException {
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainOutParameter(DomainOutParameter<V, D> parameter, Void p) throws SQLException {
            this.handleOutParameter(parameter);
            ++this.index;
            return null;
        }

        protected void handleOutParameter(OutParameter<?> parameter) throws SQLException {
            parameter.getWrapper().accept(this.jdbcMappingVisitor, new GetOutParameterFunction(this.callableStatement, this.index));
            parameter.update();
        }

        @Override
        public <V> Void visitBasicResultParameter(BasicResultParameter<V> parameter, Void p) throws SQLException {
            parameter.getWrapper().accept(this.jdbcMappingVisitor, new GetOutParameterFunction(this.callableStatement, this.index));
            ++this.index;
            return null;
        }

        @Override
        public <V, D> Void visitDomainResultParameter(DomainResultParameter<V, D> parameter, Void p) throws SQLException {
            Wrapper<V> wrapper = parameter.getWrapper();
            wrapper.accept(this.jdbcMappingVisitor, new GetOutParameterFunction(this.callableStatement, this.index));
            ++this.index;
            return null;
        }

        @Override
        public <V> Void visitBasicListParameter(BasicListParameter<V> parameter, Void p) throws SQLException {
            this.handleListParameter(new BasicFetcherCallback<V>(parameter));
            return null;
        }

        @Override
        public <V, D> Void visitDomainListParameter(DomainListParameter<V, D> parameter, Void p) throws SQLException {
            this.handleListParameter(new DomainFetcherCallback<V, D>(parameter));
            return null;
        }

        @Override
        public <E> Void visitEntityListParameter(EntityListParameter<E> parameter, Void p) throws SQLException {
            this.handleListParameter(new EntityFetcherCallback<E>(parameter));
            return null;
        }

        @Override
        public Void visitMapListParameter(MapListParameter parameter, Void p) throws SQLException {
            this.handleListParameter(new MapFetcherCallback(parameter));
            return null;
        }

        @Override
        public <V> Void visitBasicListResultParameter(BasicListResultParameter<V> parameter, Void p) throws SQLException {
            this.handleListParameter(new BasicFetcherCallback<V>(parameter));
            return null;
        }

        @Override
        public <V, D> Void visitDomainListResultParameter(DomainListResultParameter<V, D> parameter, Void p) throws SQLException {
            this.handleListParameter(new DomainFetcherCallback<V, D>(parameter));
            return null;
        }

        @Override
        public <E> Void visitEntityListResultParameter(EntityListResultParameter<E> parameter, Void p) throws SQLException {
            this.handleListParameter(new EntityFetcherCallback<E>(parameter));
            return null;
        }

        @Override
        public Void visitMapListResultParameter(MapListResultParameter parameter, Void p) throws SQLException {
            this.handleListParameter(new MapFetcherCallback(parameter));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleListParameter(FetcherCallback callback) throws SQLException {
            if (this.dialect.supportsResultSetReturningAsOutParameter()) {
                JdbcType<ResultSet> resultSetType = this.dialect.getResultSetType();
                ResultSet resultSet = resultSetType.getValue(this.callableStatement, this.index);
                if (resultSet == null) {
                    throw new JdbcException((MessageResource)Message.DOMA2137, this.index, callback.getParameterName(), this.query.getModuleName());
                }
                try {
                    while (resultSet.next()) {
                        callback.fetch(resultSet);
                    }
                }
                finally {
                    JdbcUtil.close(resultSet, this.query.getConfig().getJdbcLogger());
                }
                ++this.index;
            } else {
                ResultSet resultSet = this.callableStatement.getResultSet();
                while (resultSet == null && (this.callableStatement.getMoreResults() || this.callableStatement.getUpdateCount() > -1)) {
                    resultSet = this.callableStatement.getResultSet();
                }
                if (resultSet == null) {
                    throw new JdbcException((MessageResource)Message.DOMA2136, callback.getParameterName(), this.query.getModuleName());
                }
                try {
                    while (resultSet.next()) {
                        callback.fetch(resultSet);
                    }
                }
                finally {
                    this.callableStatement.getMoreResults(1);
                }
            }
        }

        protected class BasicFetcherCallback<V>
        implements FetcherCallback {
            protected BasicFetcher fetcher;
            protected BasicListParameter<V> parameter;

            public BasicFetcherCallback(BasicListParameter<V> parameter) {
                this.fetcher = new BasicFetcher(FetchingVisitor.this.query);
                this.parameter = parameter;
            }

            @Override
            public void fetch(ResultSet resultSet) throws SQLException {
                Wrapper<V> wrapper = this.parameter.getWrapper();
                this.fetcher.fetch(resultSet, wrapper);
                this.parameter.add(wrapper.get());
            }

            @Override
            public String getParameterName() {
                return this.parameter.getName();
            }
        }

        protected class DomainFetcherCallback<V, D>
        implements FetcherCallback {
            protected BasicFetcher fetcher;
            protected DomainListParameter<V, D> parameter;

            public DomainFetcherCallback(DomainListParameter<V, D> parameter) {
                this.fetcher = new BasicFetcher(FetchingVisitor.this.query);
                this.parameter = parameter;
            }

            @Override
            public void fetch(ResultSet resultSet) throws SQLException {
                DomainWrapper<V, D> wrapper = this.parameter.getWrapper();
                this.fetcher.fetch(resultSet, (Wrapper<?>)wrapper);
                this.parameter.add(wrapper.getDomain());
            }

            @Override
            public String getParameterName() {
                return this.parameter.getName();
            }
        }

        protected class MapFetcherCallback
        implements FetcherCallback {
            protected MapFetcher fetcher;
            protected MapListParameter parameter;

            public MapFetcherCallback(MapListParameter parameter) {
                this.fetcher = new MapFetcher(FetchingVisitor.this.query, parameter.getMapKeyNamingType());
                this.parameter = parameter;
            }

            @Override
            public void fetch(ResultSet resultSet) throws SQLException {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                this.fetcher.fetch(resultSet, (Map<String, Object>)map);
                this.parameter.add((Map<String, Object>)map);
            }

            @Override
            public String getParameterName() {
                return this.parameter.getName();
            }
        }

        protected class EntityFetcherCallback<E>
        implements FetcherCallback {
            protected EntityBuilder<E> builder;
            protected EntityListParameter<E> parameter;
            protected EntityType<E> entityType;

            public EntityFetcherCallback(EntityListParameter<E> parameter) {
                this.entityType = parameter.getEntityType();
                this.builder = new EntityBuilder<E>(FetchingVisitor.this.query, this.entityType, parameter.isResultMappingEnsured());
                this.parameter = parameter;
            }

            @Override
            public void fetch(ResultSet resultSet) throws SQLException {
                E entity = this.builder.build(resultSet);
                this.parameter.add(entity);
            }

            @Override
            public String getParameterName() {
                return this.parameter.getName();
            }
        }

        protected static interface FetcherCallback {
            public String getParameterName();

            public void fetch(ResultSet var1) throws SQLException;
        }
    }
}

