/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.domain;

import example.domain.PhoneNumber;
import junit.framework.TestCase;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.DefaultClassHelper;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainTypeFactory;
import org.seasar.doma.jdbc.domain.DomainTypeNotFoundException;
import org.seasar.doma.jdbc.domain.Money;

public class DomainTypeFactoryTest
extends TestCase {
    public void testGetDomainType() throws Exception {
        DomainType type = DomainTypeFactory.getDomainType(PhoneNumber.class, (ClassHelper)new DefaultClassHelper());
        DomainTypeFactoryTest.assertNotNull((Object)type);
    }

    public void testGetDomainType_DomaIllegalArgumentException() throws Exception {
        try {
            DomainTypeFactory.getDomainType(Object.class, (ClassHelper)new DefaultClassHelper());
            DomainTypeFactoryTest.fail();
        }
        catch (DomaIllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    public void testGetDomainType_DomainTypeNotFoundException() throws Exception {
        try {
            DomainTypeFactory.getDomainType(Money.class, (ClassHelper)new DefaultClassHelper());
            DomainTypeFactoryTest.fail();
        }
        catch (DomainTypeNotFoundException e) {
            System.out.println(e.getMessage());
        }
    }
}

