/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import junit.framework.TestCase;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.sql.ConvertToLogFormatFunction;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.dialect.OracleDialect;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class OracleDialectTest
extends TestCase {
    public void testExpressionFunctions_prefix() throws Exception {
        OracleDialect dialect = new OracleDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        OracleDialectTest.assertEquals((String)"a$$a$%a$_a$\uff05a$\uff3f%", (String)functions.prefix("a$a%a_a\uff05a\uff3f"));
    }

    public void testExpressionFunctions_prefix_escape() throws Exception {
        OracleDialect dialect = new OracleDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        OracleDialectTest.assertEquals((String)"a!!a!%a!_a!\uff05a!\uff3f%", (String)functions.prefix("a!a%a_a\uff05a\uff3f", '!'));
    }

    public void testExpressionFunctions_prefix_escapeWithBackslash() throws Exception {
        OracleDialect dialect = new OracleDialect();
        ExpressionFunctions functions = dialect.getExpressionFunctions();
        OracleDialectTest.assertEquals((String)"a\\\\a\\%a\\_a\\\uff05a\\\uff3f%", (String)functions.prefix("a\\a%a_a\uff05a\uff3f", '\\'));
    }

    public void testDateFormat() throws Exception {
        OracleDialect dialect = new OracleDialect();
        SqlLogFormattingVisitor visitor = dialect.getSqlLogFormattingVisitor();
        DateWrapper wrapper = new DateWrapper(Date.valueOf("2009-01-23"));
        OracleDialectTest.assertEquals((String)"date'2009-01-23'", (String)((String)wrapper.accept((WrapperVisitor)visitor, (Object)new ConvertToLogFormatFunction())));
    }

    public void testTimeFormat() throws Exception {
        OracleDialect dialect = new OracleDialect();
        SqlLogFormattingVisitor visitor = dialect.getSqlLogFormattingVisitor();
        TimeWrapper wrapper = new TimeWrapper(Time.valueOf("01:23:45"));
        OracleDialectTest.assertEquals((String)"time'01:23:45'", (String)((String)wrapper.accept((WrapperVisitor)visitor, (Object)new ConvertToLogFormatFunction())));
    }

    public void testTimestampFormat() throws Exception {
        OracleDialect dialect = new OracleDialect();
        SqlLogFormattingVisitor visitor = dialect.getSqlLogFormattingVisitor();
        TimestampWrapper wrapper = new TimestampWrapper(Timestamp.valueOf("2009-01-23 01:23:45.123456789"));
        OracleDialectTest.assertEquals((String)"timestamp'2009-01-23 01:23:45.123456789'", (String)((String)wrapper.accept((WrapperVisitor)visitor, (Object)new ConvertToLogFormatFunction())));
    }

    public void testUtilDateFormat() throws Exception {
        OracleDialect dialect = new OracleDialect();
        SqlLogFormattingVisitor visitor = dialect.getSqlLogFormattingVisitor();
        UtilDateWrapper wrapper = new UtilDateWrapper(new SimpleDateFormat("yyyy-MM-dd HH:mm:sss.SSS").parse("2009-01-23 12:34:56.789"));
        OracleDialectTest.assertEquals((String)"timestamp'2009-01-23 12:34:56.789'", (String)((String)wrapper.accept((WrapperVisitor)visitor, (Object)new ConvertToLogFormatFunction())));
    }
}

