/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.dialect.StandardPagingTransformer;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;

public class StandardPagingTransformerTest
extends TestCase {
    public void testOffsetLimit() throws Exception {
        String expected = "select * from ( select temp_.*, row_number() over( order by temp_.id ) as doma_rownumber_ from ( select emp.id from emp ) as temp_ ) as temp2_ where doma_rownumber_ > 5 and doma_rownumber_ <= 15";
        StandardPagingTransformer transformer = new StandardPagingTransformer(5L, 10L);
        SqlParser parser = new SqlParser("select emp.id from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        StandardPagingTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }

    public void testOffsetOnly() throws Exception {
        String expected = "select * from ( select temp_.*, row_number() over( order by temp_.id ) as doma_rownumber_ from ( select emp.id from emp ) as temp_ ) as temp2_ where doma_rownumber_ > 5";
        StandardPagingTransformer transformer = new StandardPagingTransformer(5L, -1L);
        SqlParser parser = new SqlParser("select emp.id from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        StandardPagingTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }

    public void testLimitOnly() throws Exception {
        String expected = "select * from ( select temp_.*, row_number() over( order by temp_.id ) as doma_rownumber_ from ( select emp.id from emp ) as temp_ ) as temp2_ where doma_rownumber_ <= 10";
        StandardPagingTransformer transformer = new StandardPagingTransformer(-1L, 10L);
        SqlParser parser = new SqlParser("select emp.id from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        StandardPagingTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }

    public void testOrderByClauseUnspecified() throws Exception {
        StandardPagingTransformer transformer = new StandardPagingTransformer(5L, 10L);
        SqlParser parser = new SqlParser("select * from emp");
        try {
            transformer.transform(parser.parse());
            StandardPagingTransformerTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println(expected.getMessage());
            StandardPagingTransformerTest.assertEquals((Object)Message.DOMA2201, (Object)expected.getMessageResource());
        }
    }
}

