/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.dialect.StandardCountGettingTransformer;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;

public class StandardCountGettingTransformerTest
extends TestCase {
    public void test() throws Exception {
        String expected = "select count(*) from ( select * from emp) t_";
        StandardCountGettingTransformer transformer = new StandardCountGettingTransformer();
        SqlParser parser = new SqlParser("select * from emp");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        StandardCountGettingTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }

    public void testOrderBy() throws Exception {
        String expected = "select count(*) from ( select * from emp ) t_";
        StandardCountGettingTransformer transformer = new StandardCountGettingTransformer();
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        StandardCountGettingTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }
}

