/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.CallableSqlParameterBinder;
import org.seasar.doma.internal.jdbc.mock.BindValue;
import org.seasar.doma.internal.jdbc.mock.MockCallableStatement;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.RegisterOutParameter;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Reference;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class CallableSqlParameterBinderTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testBind() throws Exception {
        MockCallableStatement callableStatement = new MockCallableStatement();
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(new BasicResultParameter((Wrapper)new IntegerWrapper(), false));
        parameters.add(new BasicInParameter((Wrapper)new StringWrapper("aaa")));
        parameters.add(new BasicInOutParameter((Wrapper)new BigDecimalWrapper(), new Reference((Object)new BigDecimal(10))));
        parameters.add(new BasicOutParameter((Wrapper)new StringWrapper("bbb"), new Reference()));
        CallableSqlParameterBinder binder = new CallableSqlParameterBinder((Query)new MyQuery());
        binder.bind((CallableStatement)callableStatement, parameters);
        List bindValues = callableStatement.bindValues;
        CallableSqlParameterBinderTest.assertEquals((int)2, (int)bindValues.size());
        BindValue bindValue = (BindValue)bindValues.get(0);
        CallableSqlParameterBinderTest.assertEquals((int)2, (int)bindValue.getIndex());
        CallableSqlParameterBinderTest.assertEquals((Object)"aaa", (Object)bindValue.getValue());
        bindValue = (BindValue)bindValues.get(1);
        CallableSqlParameterBinderTest.assertEquals((int)3, (int)bindValue.getIndex());
        CallableSqlParameterBinderTest.assertEquals((Object)new BigDecimal(10), (Object)bindValue.getValue());
        List<RegisterOutParameter> registerOutParameters = callableStatement.registerOutParameters;
        CallableSqlParameterBinderTest.assertEquals((int)3, (int)registerOutParameters.size());
    }

    protected class MyQuery
    implements Query {
        protected MyQuery() {
        }

        public Sql<?> getSql() {
            return null;
        }

        public Config getConfig() {
            return CallableSqlParameterBinderTest.this.runtimeConfig;
        }

        public String getClassName() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public int getQueryTimeout() {
            return 0;
        }

        public void prepare() {
        }

        public void complete() {
        }
    }
}

