/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr.node;

import junit.framework.TestCase;
import org.seasar.doma.internal.expr.EvaluationResult;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.node.AndOperatorNode;
import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.LiteralNode;

public class AndOperatorNodeTest
extends TestCase {
    protected ExpressionLocation location = new ExpressionLocation("", 0);
    protected LiteralNode trueLiteral = new LiteralNode(this.location, "true", (Object)true, Boolean.TYPE);
    protected LiteralNode falseLiteral = new LiteralNode(this.location, "false", (Object)false, Boolean.TYPE);
    protected LiteralNode nullLiteral = new LiteralNode(this.location, "null", null, Object.class);

    public void test_true_true() throws Exception {
        AndOperatorNode node = new AndOperatorNode(this.location, "&&");
        node.setLeftNode((ExpressionNode)this.trueLiteral);
        node.setRightNode((ExpressionNode)this.trueLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        AndOperatorNodeTest.assertTrue((boolean)evaluationResult.getBooleanValue());
    }

    public void test_true_false() throws Exception {
        AndOperatorNode node = new AndOperatorNode(this.location, "&&");
        node.setLeftNode((ExpressionNode)this.trueLiteral);
        node.setRightNode((ExpressionNode)this.falseLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        AndOperatorNodeTest.assertFalse((boolean)evaluationResult.getBooleanValue());
    }

    public void test_false_true() throws Exception {
        AndOperatorNode node = new AndOperatorNode(this.location, "&&");
        node.setLeftNode((ExpressionNode)this.falseLiteral);
        node.setRightNode((ExpressionNode)this.trueLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        AndOperatorNodeTest.assertFalse((boolean)evaluationResult.getBooleanValue());
    }

    public void test_false_false() throws Exception {
        AndOperatorNode node = new AndOperatorNode(this.location, "&&");
        node.setLeftNode((ExpressionNode)this.falseLiteral);
        node.setRightNode((ExpressionNode)this.falseLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        AndOperatorNodeTest.assertFalse((boolean)evaluationResult.getBooleanValue());
    }

    public void test_null_null() throws Exception {
        AndOperatorNode node = new AndOperatorNode(this.location, "&&");
        node.setLeftNode((ExpressionNode)this.nullLiteral);
        node.setRightNode((ExpressionNode)this.nullLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        AndOperatorNodeTest.assertFalse((boolean)evaluationResult.getBooleanValue());
    }

    public void test_null_notNull() throws Exception {
        AndOperatorNode node = new AndOperatorNode(this.location, "&&");
        node.setLeftNode((ExpressionNode)this.nullLiteral);
        node.setRightNode((ExpressionNode)this.trueLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        AndOperatorNodeTest.assertFalse((boolean)evaluationResult.getBooleanValue());
    }

    public void test_notNull_null() throws Exception {
        AndOperatorNode node = new AndOperatorNode(this.location, "&&");
        node.setLeftNode((ExpressionNode)this.trueLiteral);
        node.setRightNode((ExpressionNode)this.nullLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        AndOperatorNodeTest.assertFalse((boolean)evaluationResult.getBooleanValue());
    }
}

