/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import javax.sql.DataSource;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.tx.LocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;

public class KeepAliveLocalTransaction
extends LocalTransaction {
    protected KeepAliveLocalTransaction(DataSource dataSource, ThreadLocal<LocalTransactionContext> localTxContextHolder, JdbcLogger jdbcLogger) {
        super(dataSource, localTxContextHolder, jdbcLogger);
    }

    protected KeepAliveLocalTransaction(DataSource dataSource, ThreadLocal<LocalTransactionContext> localTxContextHolder, JdbcLogger jdbcLogger, TransactionIsolationLevel defaultTransactionIsolationLevel) {
        super(dataSource, localTxContextHolder, jdbcLogger, defaultTransactionIsolationLevel);
    }

    public void init() {
        this.createLocalTransactionContext();
    }

    @Override
    protected LocalTransactionContext createLocalTransactionContext() {
        LocalTransactionContext context = (LocalTransactionContext)this.localTxContextHolder.get();
        if (context != null) {
            return context;
        }
        return super.createLocalTransactionContext();
    }

    public void destroy() {
        LocalTransactionContext context = (LocalTransactionContext)this.localTxContextHolder.get();
        if (context == null) {
            return;
        }
        this.release(context, "destroy");
    }

    @Override
    protected void endInternal(LocalTransactionContext context, String callerMethodName) {
        this.jdbcLogger.logLocalTransactionEnded(this.className, callerMethodName, context.getId());
        context.setId(null);
    }

    @Override
    protected boolean isActiveInternal(LocalTransactionContext context) {
        return context != null && context.getId() != null;
    }
}

