/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.meta.ExternalDomainMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.EnumDomainMirror;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainConverter;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ExternalDomainMetaFactory
implements TypeElementMetaFactory<ExternalDomainMeta> {
    private final ProcessingEnvironment env;

    public ExternalDomainMetaFactory(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    @Override
    public ExternalDomainMeta createTypeElementMeta(TypeElement convElement) {
        this.validateConverter(convElement);
        TypeMirror[] argTypes = this.getConverterArgTypes(convElement.asType());
        if (argTypes == null) {
            throw new AptIllegalStateException("converter doesn't have type args: " + convElement.getQualifiedName());
        }
        ExternalDomainMeta meta = new ExternalDomainMeta(convElement);
        this.doDomainType(convElement, argTypes[0], meta);
        this.doValueType(convElement, argTypes[1], meta);
        return meta;
    }

    protected void validateConverter(TypeElement convElement) {
        if (!TypeMirrorUtil.isAssignable(convElement.asType(), DomainConverter.class, this.env)) {
            throw new AptException((MessageResource)Message.DOMA4191, this.env, (Element)convElement, new Object[0]);
        }
        if (convElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4198, this.env, (Element)convElement, new Object[0]);
        }
        if (convElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4192, this.env, (Element)convElement, convElement.getQualifiedName());
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(convElement, this.env);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4193, this.env, (Element)convElement, convElement.getQualifiedName());
        }
    }

    protected TypeMirror[] getConverterArgTypes(TypeMirror typeMirror) {
        for (TypeMirror typeMirror2 : this.env.getTypeUtils().directSupertypes(typeMirror)) {
            if (!TypeMirrorUtil.isAssignable(typeMirror2, DomainConverter.class, this.env)) continue;
            if (TypeMirrorUtil.isSameType(typeMirror2, DomainConverter.class, this.env)) {
                DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror2, this.env);
                AssertionUtil.assertNotNull(declaredType);
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                AssertionUtil.assertEquals(2, args.size());
                return new TypeMirror[]{args.get(0), args.get(1)};
            }
            TypeMirror[] argTypes = this.getConverterArgTypes(typeMirror2);
            if (argTypes == null) continue;
            return argTypes;
        }
        return null;
    }

    protected void doDomainType(TypeElement convElement, TypeMirror domainType, ExternalDomainMeta meta) {
        TypeElement domainElement = TypeMirrorUtil.toTypeElement(domainType, this.env);
        if (domainElement == null) {
            throw new AptIllegalStateException(domainType.toString());
        }
        if (domainElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4199, this.env, (Element)convElement, domainElement.getQualifiedName());
        }
        PackageElement pkgElement = this.env.getElementUtils().getPackageOf(domainElement);
        if (pkgElement.isUnnamed()) {
            throw new AptException((MessageResource)Message.DOMA4197, this.env, (Element)convElement, domainElement.getQualifiedName());
        }
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(domainType, this.env);
        if (declaredType == null) {
            throw new AptIllegalStateException(domainType.toString());
        }
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (typeMirror.getKind() == TypeKind.WILDCARD) continue;
            throw new AptException((MessageResource)Message.DOMA4203, this.env, (Element)convElement, domainElement.getQualifiedName());
        }
        meta.setDomainElement(domainElement);
    }

    protected void doValueType(TypeElement convElement, TypeMirror valueType, ExternalDomainMeta meta) {
        EnumDomainMirror enumDomainMirror;
        TypeElement valueElement = TypeMirrorUtil.toTypeElement(valueType, this.env);
        if (valueElement == null) {
            throw new AptIllegalStateException(valueType.toString());
        }
        meta.setValueElement(valueElement);
        BasicType basicType = BasicType.newInstance(valueType, this.env);
        if (basicType == null) {
            throw new AptException((MessageResource)Message.DOMA4194, this.env, (Element)convElement, valueElement.getQualifiedName());
        }
        if (basicType.isEnum() && (enumDomainMirror = EnumDomainMirror.newInstance(valueElement, this.env)) != null) {
            throw new AptException((MessageResource)Message.DOMA4195, this.env, (Element)convElement, basicType.getQualifiedName());
        }
        meta.setWrapperType(basicType.getWrapperType());
    }
}

