/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.type.JdbcType;

public abstract class AbstractJdbcType<T>
implements JdbcType<T> {
    protected final int type;

    protected AbstractJdbcType(int type) {
        this.type = type;
    }

    @Override
    public T getValue(ResultSet resultSet, int index) throws SQLException {
        if (resultSet == null) {
            throw new DomaNullPointerException("resultSet");
        }
        if (index < 1) {
            throw new DomaIllegalArgumentException("index", "index < 1");
        }
        T result = this.doGetValue(resultSet, index);
        if (resultSet.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public void setValue(PreparedStatement preparedStatement, int index, T value) throws SQLException {
        if (preparedStatement == null) {
            throw new DomaNullPointerException("preparedStatement");
        }
        if (index < 1) {
            throw new DomaIllegalArgumentException("index", "index < 1");
        }
        if (value == null) {
            preparedStatement.setNull(index, this.type);
        } else {
            this.doSetValue(preparedStatement, index, value);
        }
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, int index) throws SQLException {
        if (callableStatement == null) {
            throw new DomaNullPointerException("callableStatement");
        }
        if (index < 1) {
            throw new DomaIllegalArgumentException("index", "index < 1");
        }
        callableStatement.registerOutParameter(index, this.type);
    }

    @Override
    public T getValue(CallableStatement callableStatement, int index) throws SQLException {
        if (callableStatement == null) {
            throw new DomaNullPointerException("callableStatement");
        }
        if (index < 1) {
            throw new DomaIllegalArgumentException("index", "index < 1");
        }
        T result = this.doGetValue(callableStatement, index);
        if (callableStatement.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public String convertToLogFormat(T value) {
        if (value == null) {
            return "null";
        }
        return this.doConvertToLogFormat(value);
    }

    protected abstract T doGetValue(ResultSet var1, int var2) throws SQLException;

    protected abstract void doSetValue(PreparedStatement var1, int var2, T var3) throws SQLException;

    protected abstract T doGetValue(CallableStatement var1, int var2) throws SQLException;

    protected abstract String doConvertToLogFormat(T var1);
}

