/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.wrapper;

import example.domain.InternationalPhoneNumber;
import example.domain.PhoneNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.TestCase;
import org.seasar.doma.internal.wrapper.Wrappers;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.DefaultClassHelper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class WrappersTest
extends TestCase {
    private final ClassHelper classHelper = new DefaultClassHelper();

    public void testWrap() throws Exception {
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)true, Boolean.TYPE, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)true, Boolean.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)1, Byte.TYPE, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new Byte(1), Byte.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)1, Short.TYPE, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new Short(1), Short.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)1, Integer.TYPE, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new Integer(1), Integer.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)1L, Long.TYPE, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new Long(1L), Long.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)Float.valueOf(1.0f), Float.TYPE, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new Float(1.0f), Float.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)1.0, Double.TYPE, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new Double(1.0), Double.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new byte[]{1}, byte[].class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)"", String.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new BigDecimal("1"), BigDecimal.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new BigInteger("1"), BigInteger.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)Date.valueOf("2009-01-23"), Date.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)Time.valueOf("12:34:56"), Time.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)Timestamp.valueOf("2009-01-23 12:34:56"), Timestamp.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap((Object)new java.util.Date(), java.util.Date.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap(null, Array.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap(null, Blob.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap(null, Clob.class, (ClassHelper)this.classHelper));
        WrappersTest.assertNotNull((Object)Wrappers.wrap(null, NClob.class, (ClassHelper)this.classHelper));
    }

    public void testWrapBasic_boxedValue_primitiveType() throws Exception {
        Wrapper wrapper = Wrappers.wrap((Object)new Integer(10), Integer.TYPE, (ClassHelper)this.classHelper);
        WrappersTest.assertNotNull((Object)wrapper);
        WrappersTest.assertEquals(IntegerWrapper.class, wrapper.getClass());
        WrappersTest.assertEquals((Object)new Integer(10), (Object)wrapper.get());
    }

    public void testWrapBasic_null() throws Exception {
        Wrapper wrapper = Wrappers.wrap(null, Integer.class, (ClassHelper)this.classHelper);
        WrappersTest.assertNotNull((Object)wrapper);
        WrappersTest.assertEquals(IntegerWrapper.class, wrapper.getClass());
        WrappersTest.assertNull(null, (Object)wrapper.get());
    }

    public void testWrapEnum() throws Exception {
        Wrapper wrapper = Wrappers.wrap((Object)((Object)MyEnum.AAA), MyEnum.class, (ClassHelper)this.classHelper);
        WrappersTest.assertNotNull((Object)wrapper);
        WrappersTest.assertEquals(EnumWrapper.class, wrapper.getClass());
        WrappersTest.assertEquals((Object)((Object)MyEnum.AAA), (Object)wrapper.get());
    }

    public void testWrapEnum_null() throws Exception {
        Wrapper wrapper = Wrappers.wrap(null, MyEnum.class, (ClassHelper)this.classHelper);
        WrappersTest.assertNotNull((Object)wrapper);
        WrappersTest.assertEquals(EnumWrapper.class, wrapper.getClass());
        WrappersTest.assertNull((Object)wrapper.get());
    }

    public void testWrapDomain() throws Exception {
        PhoneNumber phoneNumber = new PhoneNumber("123-456-789");
        Wrapper wrapper = Wrappers.wrap((Object)phoneNumber, PhoneNumber.class, (ClassHelper)this.classHelper);
        WrappersTest.assertNotNull((Object)wrapper);
        WrappersTest.assertEquals(StringWrapper.class, wrapper.getClass());
        WrappersTest.assertEquals((Object)"123-456-789", (Object)wrapper.get());
    }

    public void testWrapDomain_subclass() throws Exception {
        InternationalPhoneNumber phoneNumber = new InternationalPhoneNumber("123-456-789");
        Wrapper wrapper = Wrappers.wrap((Object)phoneNumber, InternationalPhoneNumber.class, (ClassHelper)this.classHelper);
        WrappersTest.assertNotNull((Object)wrapper);
        WrappersTest.assertEquals(StringWrapper.class, wrapper.getClass());
        WrappersTest.assertEquals((Object)"123-456-789", (Object)wrapper.get());
    }

    public void testWrapDomain_null() throws Exception {
        Wrapper wrapper = Wrappers.wrap(null, PhoneNumber.class, (ClassHelper)this.classHelper);
        WrappersTest.assertNotNull((Object)wrapper);
        WrappersTest.assertEquals(StringWrapper.class, wrapper.getClass());
        WrappersTest.assertNull((Object)wrapper.get());
    }

    public static enum MyEnum {
        AAA,
        BBB,
        CCC;

    }
}

