/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.dialect.PostgresForUpdateTransformer;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;

public class PostgresForUpdateTransformerTest
extends TestCase {
    public void testForUpdateNormal() throws Exception {
        String expected = "select * from emp order by emp.id for update";
        PostgresForUpdateTransformer transformer = new PostgresForUpdateTransformer(SelectForUpdateType.NORMAL, 0, new String[0]);
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        PostgresForUpdateTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }

    public void testForUpdateNormal_alias() throws Exception {
        String expected = "select * from emp order by emp.id for update of emp";
        PostgresForUpdateTransformer transformer = new PostgresForUpdateTransformer(SelectForUpdateType.NORMAL, 0, new String[]{"emp"});
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        PostgresForUpdateTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }

    public void testForUpdateNowait() throws Exception {
        String expected = "select * from emp order by emp.id for update nowait";
        PostgresForUpdateTransformer transformer = new PostgresForUpdateTransformer(SelectForUpdateType.NOWAIT, 0, new String[0]);
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        PostgresForUpdateTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }

    public void testForUpdateNowait_alias() throws Exception {
        String expected = "select * from emp order by emp.id for update of emp nowait";
        PostgresForUpdateTransformer transformer = new PostgresForUpdateTransformer(SelectForUpdateType.NOWAIT, 0, new String[]{"emp"});
        SqlParser parser = new SqlParser("select * from emp order by emp.id");
        SqlNode sqlNode = transformer.transform(parser.parse());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder((Config)new MockConfig(), SqlKind.SELECT, "dummyPath");
        PreparedSql sql = sqlBuilder.build(sqlNode);
        PostgresForUpdateTransformerTest.assertEquals((String)expected, (String)sql.getRawSql());
    }
}

