/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.sql.ResultSet;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.EntityResultListHandler;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileSelectQuery;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntityResultListHandlerTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testHandle() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData(1, "aaa"));
        resultSet.rows.add(new RowData(2, "bbb"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        EntityResultListHandler handler = new EntityResultListHandler((EntityType)_Emp.getSingletonInternal());
        List entities = handler.handle((ResultSet)resultSet, (SelectQuery)query);
        EntityResultListHandlerTest.assertEquals((int)2, (int)entities.size());
        Emp emp = (Emp)entities.get(0);
        EntityResultListHandlerTest.assertEquals((Object)new Integer(1), (Object)emp.getId());
        EntityResultListHandlerTest.assertEquals((String)"aaa", (String)emp.getName());
        emp = (Emp)entities.get(1);
        EntityResultListHandlerTest.assertEquals((Object)new Integer(2), (Object)emp.getId());
        EntityResultListHandlerTest.assertEquals((String)"bbb", (String)emp.getName());
    }

    public void testHandle_NoResultException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setResultEnsured(true);
        query.prepare();
        EntityResultListHandler handler = new EntityResultListHandler((EntityType)_Emp.getSingletonInternal());
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            EntityResultListHandlerTest.fail();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }
}

