/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.domain.PhoneNumber;
import example.domain._PhoneNumber;
import java.sql.ResultSet;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.DomainSingleResultHandler;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileSelectQuery;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.NonUniqueResultException;
import org.seasar.doma.jdbc.domain.DomainType;

public class DomainSingleResultHandlerTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testHandle() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("x"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("01-2345-6789"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        DomainSingleResultHandler handler = new DomainSingleResultHandler((DomainType)_PhoneNumber.getSingletonInternal());
        PhoneNumber result = (PhoneNumber)handler.handle((ResultSet)resultSet, (SelectQuery)query);
        DomainSingleResultHandlerTest.assertEquals((String)"01-2345-6789", (String)result.getValue());
    }

    public void testHandle_NonUniqueResultException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("phoneNumber"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("01-2345-6789"));
        resultSet.rows.add(new RowData("02-2345-6789"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        DomainSingleResultHandler handler = new DomainSingleResultHandler((DomainType)_PhoneNumber.getSingletonInternal());
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            DomainSingleResultHandlerTest.fail();
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            // empty catch block
        }
    }

    public void testHandle_NoResultException() throws Exception {
        MockResultSet resultSet = new MockResultSet();
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setResultEnsured(true);
        query.prepare();
        DomainSingleResultHandler handler = new DomainSingleResultHandler((DomainType)_PhoneNumber.getSingletonInternal());
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            DomainSingleResultHandlerTest.fail();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }
}

