/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.domain.PhoneNumber;
import example.domain._PhoneNumber;
import java.sql.ResultSet;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.DomainResultListHandler;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileSelectQuery;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.domain.DomainType;

public class DomainResultListHandlerTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testHandle() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("x"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("01-2345-6789"));
        resultSet.rows.add(new RowData("12-3456-7890"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        DomainResultListHandler handler = new DomainResultListHandler((DomainType)_PhoneNumber.getSingletonInternal());
        List results = handler.handle((ResultSet)resultSet, (SelectQuery)query);
        DomainResultListHandlerTest.assertEquals((int)2, (int)results.size());
        DomainResultListHandlerTest.assertEquals((String)"01-2345-6789", (String)((PhoneNumber)results.get(0)).getValue());
        DomainResultListHandlerTest.assertEquals((String)"12-3456-7890", (String)((PhoneNumber)results.get(1)).getValue());
    }

    public void testHandle_NoResultException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("x"));
        MockResultSet resultSet = new MockResultSet(metaData);
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setResultEnsured(true);
        query.prepare();
        DomainResultListHandler handler = new DomainResultListHandler((DomainType)_PhoneNumber.getSingletonInternal());
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            DomainResultListHandlerTest.fail();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }
}

