/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr;

import junit.framework.TestCase;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionParser;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.message.Message;

public class ExpressionExceptionTest
extends TestCase {
    public void testMethodInvocationFailed() throws Exception {
        ExpressionParser parser = new ExpressionParser("new java.util.ArrayList().get(0)");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3001, (Object)e.getMessageResource());
        }
    }

    public void testMethodNotFound() throws Exception {
        ExpressionParser parser = new ExpressionParser("\"aaa\".bbb()");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3002, (Object)e.getMessageResource());
        }
    }

    public void testVariableUnresolvable() throws Exception {
        ExpressionParser parser = new ExpressionParser("aaa.eq(100)");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3003, (Object)e.getMessageResource());
        }
    }

    public void testDoubleQuotationNotClosed() throws Exception {
        ExpressionParser parser = new ExpressionParser("\"bbb\" == \"bbb");
        try {
            parser.parse();
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3004, (Object)e.getMessageResource());
        }
    }

    public void testClassNotFound() throws Exception {
        ExpressionParser parser = new ExpressionParser("new MyString()");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3005, (Object)e.getMessageResource());
        }
    }

    public void testConstructorNotFound() throws Exception {
        ExpressionParser parser = new ExpressionParser("new java.lang.String(10B)");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3006, (Object)e.getMessageResource());
        }
    }

    public void testConstructorInvocationFailed() throws Exception {
        ExpressionParser parser = new ExpressionParser("new java.util.ArrayList(-1)");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3007, (Object)e.getMessageResource());
        }
    }

    public void testComparisonFailed_incomparable() throws Exception {
        ExpressionParser parser = new ExpressionParser("1 > true");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3008, (Object)e.getMessageResource());
        }
    }

    public void testComparisonFailed_null() throws Exception {
        ExpressionParser parser = new ExpressionParser("1 > null");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3009, (Object)e.getMessageResource());
        }
    }

    public void testOperandNotFound() throws Exception {
        ExpressionParser parser = new ExpressionParser("true &&");
        try {
            parser.parse();
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3010, (Object)e.getMessageResource());
        }
    }

    public void testUnsupportedTokenFound() throws Exception {
        ExpressionParser parser = new ExpressionParser("5 & 5");
        try {
            parser.parse();
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3011, (Object)e.getMessageResource());
        }
    }

    public void testUnsupportedNumberLiteralFound() throws Exception {
        ExpressionParser parser = new ExpressionParser("5aaa");
        try {
            parser.parse();
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3012, (Object)e.getMessageResource());
        }
    }

    public void testOperandNotNumber() throws Exception {
        ExpressionParser parser = new ExpressionParser("5 + \"10\"");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3013, (Object)e.getMessageResource());
        }
    }

    public void testOperandNotText() throws Exception {
        ExpressionParser parser = new ExpressionParser("\"10\" + 5");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3020, (Object)e.getMessageResource());
        }
    }

    public void testArithmeticOperationFailed() throws Exception {
        ExpressionParser parser = new ExpressionParser("5 / 0");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3014, (Object)e.getMessageResource());
        }
    }

    public void testArithmeticOperationFailed_null() throws Exception {
        ExpressionParser parser = new ExpressionParser("5 / null");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3015, (Object)e.getMessageResource());
        }
    }

    public void testQuotationNotClosed() throws Exception {
        ExpressionParser parser = new ExpressionParser(" 'aaa");
        try {
            parser.parse();
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3016, (Object)e.getMessageResource());
        }
    }

    public void testFieldNotFound() throws Exception {
        ExpressionParser parser = new ExpressionParser("\"aaa\".bbb");
        ExpressionNode node = parser.parse();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.evaluate(node);
            ExpressionExceptionTest.fail();
        }
        catch (ExpressionException e) {
            System.out.println(e.getMessage());
            ExpressionExceptionTest.assertEquals((Object)Message.DOMA3018, (Object)e.getMessageResource());
        }
    }
}

