/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.domain;

import javax.annotation.processing.Processor;
import junit.framework.AssertionFailedError;
import org.seasar.doma.internal.apt.AptTestCase;
import org.seasar.doma.internal.apt.ExternalDomainProcessor;
import org.seasar.doma.internal.apt.domain.AbstractDomainConverter;
import org.seasar.doma.internal.apt.domain.ConstrutorNotFoundDomainConverter;
import org.seasar.doma.internal.apt.domain.EnumDomainValueObjectConverter;
import org.seasar.doma.internal.apt.domain.IllegalParameterizedValueObjectConverter;
import org.seasar.doma.internal.apt.domain.NestingValueObjectConverter;
import org.seasar.doma.internal.apt.domain.NotDomainConverter;
import org.seasar.doma.internal.apt.domain.NotPersistentValueObjectConverter;
import org.seasar.doma.internal.apt.domain.ParameterizedValueObject;
import org.seasar.doma.internal.apt.domain.ParameterizedValueObjectConverter;
import org.seasar.doma.internal.apt.domain.ValueObject;
import org.seasar.doma.internal.apt.domain.ValueObjectConverter;
import org.seasar.doma.message.Message;

public class ExternalDomainProcessorTest
extends AptTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.addOption(new String[]{"-Atest=true"});
    }

    public void testNotDomainConverter() throws Exception {
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(NotDomainConverter.class);
        this.compile();
        ExternalDomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4191);
    }

    public void testAbstruct() throws Exception {
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(AbstractDomainConverter.class);
        this.compile();
        ExternalDomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4192);
    }

    public void testConstrutorNotFound() throws Exception {
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(ConstrutorNotFoundDomainConverter.class);
        this.compile();
        ExternalDomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4193);
    }

    public void testNotPersistent() throws Exception {
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(NotPersistentValueObjectConverter.class);
        this.compile();
        ExternalDomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4194);
    }

    public void testEnumDomain() throws Exception {
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(EnumDomainValueObjectConverter.class);
        this.compile();
        ExternalDomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4195);
    }

    public void testNestingValueObjectConverter() throws Exception {
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(NestingValueObjectConverter.class);
        this.compile();
        ExternalDomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4199);
    }

    public void testValueObjectConverter() throws Exception {
        Class<ValueObjectConverter> target = ValueObjectConverter.class;
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        String generatedClassName = "__.org.seasar.doma.internal.apt.domain._" + ValueObject.class.getSimpleName();
        try {
            this.assertEqualsGeneratedSource(this.getExpectedContent(), generatedClassName);
        }
        catch (AssertionFailedError error) {
            System.out.println(this.getGeneratedSource(generatedClassName));
            throw error;
        }
        ExternalDomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testParameterizedValueObjectConverter() throws Exception {
        Class<ParameterizedValueObjectConverter> target = ParameterizedValueObjectConverter.class;
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        String generatedClassName = "__.org.seasar.doma.internal.apt.domain._" + ParameterizedValueObject.class.getSimpleName();
        try {
            this.assertEqualsGeneratedSource(this.getExpectedContent(), generatedClassName);
        }
        catch (AssertionFailedError error) {
            System.out.println(this.getGeneratedSource(generatedClassName));
            throw error;
        }
        ExternalDomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testIllegalParameterizedValueObjectConverter() throws Exception {
        Class<IllegalParameterizedValueObjectConverter> target = IllegalParameterizedValueObjectConverter.class;
        ExternalDomainProcessor processor = new ExternalDomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        ExternalDomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4203);
    }
}

