/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.domain;

import javax.annotation.processing.Processor;
import org.seasar.doma.internal.apt.AptTestCase;
import org.seasar.doma.internal.apt.DomainProcessor;
import org.seasar.doma.internal.apt.domain.AbstractDomain;
import org.seasar.doma.internal.apt.domain.AccessorNotFoundDomain;
import org.seasar.doma.internal.apt.domain.ConstrutorNotFoundDomain;
import org.seasar.doma.internal.apt.domain.EnumDomain;
import org.seasar.doma.internal.apt.domain.IllegalSizeParametarizedOfSalary;
import org.seasar.doma.internal.apt.domain.IllegalTypeParametarizedOfSalary;
import org.seasar.doma.internal.apt.domain.JobType;
import org.seasar.doma.internal.apt.domain.OfAbstractDomain;
import org.seasar.doma.internal.apt.domain.OfEnumDomain;
import org.seasar.doma.internal.apt.domain.OfJobType;
import org.seasar.doma.internal.apt.domain.OfPrimitiveValueDomain;
import org.seasar.doma.internal.apt.domain.OfPrimitiveValueType;
import org.seasar.doma.internal.apt.domain.OfSalary;
import org.seasar.doma.internal.apt.domain.Outer;
import org.seasar.doma.internal.apt.domain.PackagePrivateDomain;
import org.seasar.doma.internal.apt.domain.ParametarizedOfSalary;
import org.seasar.doma.internal.apt.domain.ParametarizedSalary;
import org.seasar.doma.internal.apt.domain.PrimitiveValueDomain;
import org.seasar.doma.internal.apt.domain.Salary;
import org.seasar.doma.internal.apt.domain.SpecificDomain;
import org.seasar.doma.internal.apt.domain.UnsupportedValueTypeDomain;
import org.seasar.doma.internal.apt.domain.VersionCheckSuppressedDomain;
import org.seasar.doma.message.Message;

public class DomainProcessorTest
extends AptTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.addOption(new String[]{"-Atest=true"});
    }

    public void testSalary() throws Exception {
        Class<Salary> target = Salary.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testPrimitiveValue() throws Exception {
        Class<PrimitiveValueDomain> target = PrimitiveValueDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testEnum() throws Exception {
        Class<EnumDomain> target = EnumDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testUnsupportedValueType() throws Exception {
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(UnsupportedValueTypeDomain.class);
        this.compile();
        DomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4102);
    }

    public void testConstrutorNotFound() throws Exception {
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(ConstrutorNotFoundDomain.class);
        this.compile();
        DomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4103);
    }

    public void testAccessorNotFound() throws Exception {
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(AccessorNotFoundDomain.class);
        this.compile();
        DomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4104);
    }

    public void testInner() throws Exception {
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(Outer.class);
        this.compile();
        DomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4179);
    }

    public void testPackagePrivate() throws Exception {
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(PackagePrivateDomain.class);
        this.compile();
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testJobType() throws Exception {
        Class<JobType> target = JobType.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        DomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4184);
    }

    public void testAbstractDomain() throws Exception {
        Class<AbstractDomain> target = AbstractDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        DomainProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4132);
    }

    public void testOfSalary() throws Exception {
        Class<OfSalary> target = OfSalary.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testOfPrimitiveValue() throws Exception {
        Class<OfPrimitiveValueDomain> target = OfPrimitiveValueDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testOfEnum() throws Exception {
        Class<OfEnumDomain> target = OfEnumDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testOfJobType() throws Exception {
        Class<OfJobType> target = OfJobType.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testOfPrimitiveValueType() throws Exception {
        Class<OfPrimitiveValueType> target = OfPrimitiveValueType.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testOfAbstractDomain() throws Exception {
        Class<OfAbstractDomain> target = OfAbstractDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testGenericDomain() throws Exception {
        Class<SpecificDomain> target = SpecificDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testVersionCheckSuppressed() throws Exception {
        this.addOption(new String[]{"-Aversion.validation=false"});
        Class<VersionCheckSuppressedDomain> target = VersionCheckSuppressedDomain.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testParametarizedSalary() throws Exception {
        Class<ParametarizedSalary> target = ParametarizedSalary.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testParametarizedOfSalary() throws Exception {
        Class<ParametarizedOfSalary> target = ParametarizedOfSalary.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertGeneratedSource(target);
        DomainProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testIllegalSizeParametarizedOfSalary() throws Exception {
        Class<IllegalSizeParametarizedOfSalary> target = IllegalSizeParametarizedOfSalary.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertMessage(Message.DOMA4106);
    }

    public void testIllegalTypeParametarizedOfSalary() throws Exception {
        Class<IllegalTypeParametarizedOfSalary> target = IllegalTypeParametarizedOfSalary.class;
        DomainProcessor processor = new DomainProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(target);
        this.compile();
        this.assertMessage(Message.DOMA4106);
    }
}

