/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import junit.framework.AssertionFailedError;
import org.seasar.aptina.unit.AptinaTestCase;
import org.seasar.doma.Dao;
import org.seasar.doma.Domain;
import org.seasar.doma.Entity;
import org.seasar.doma.EnumDomain;
import org.seasar.doma.ExternalDomain;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.jdbc.util.MetaTypeUtil;
import org.seasar.doma.internal.util.ResourceUtil;
import org.seasar.doma.message.Message;

public abstract class AptTestCase
extends AptinaTestCase {
    protected Locale locale = Locale.JAPAN;

    protected void setUp() throws Exception {
        super.setUp();
        this.addSourcePath(new String[]{"src/test/java"});
        this.addSourcePath(new String[]{"src/test/resources"});
        this.setCharset("UTF-8");
        this.setLocale(this.locale);
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+9"));
    }

    protected void tearDown() throws Exception {
        TimeZone.setDefault(null);
        super.tearDown();
    }

    protected String getExpectedContent() throws Exception {
        String path = ((Object)((Object)this)).getClass().getName().replace(".", "/");
        String suffix = "_" + this.getName().substring("test".length()) + ".txt";
        return ResourceUtil.getResourceAsString((String)(path + suffix));
    }

    protected void assertGeneratedSource(Class<?> originalClass) throws Exception {
        String generatedClassName = this.getGeneratedClassName(originalClass);
        try {
            this.assertEqualsGeneratedSource(this.getExpectedContent(), generatedClassName);
        }
        catch (AssertionFailedError error) {
            System.out.println(this.getGeneratedSource(generatedClassName));
            throw error;
        }
    }

    protected String getGeneratedClassName(Class<?> originalClass) {
        if (originalClass.isAnnotationPresent(Dao.class)) {
            return originalClass.getName() + "Impl";
        }
        if (originalClass.isAnnotationPresent(Entity.class) || originalClass.isAnnotationPresent(Domain.class) || originalClass.isAnnotationPresent(EnumDomain.class) || originalClass.isAnnotationPresent(ExternalDomain.class)) {
            return MetaTypeUtil.getMetaTypeName((String)originalClass.getName());
        }
        throw new AssertionFailedError("annotation not found.");
    }

    protected void assertMessage(Message message) {
        List<Diagnostic<? extends JavaFileObject>> diagnostics = this.getDiagnostics();
        if (diagnostics.size() == 1) {
            Message m = this.extractMessage(diagnostics.get(0));
            if (message == m) {
                return;
            }
            AptTestCase.fail((String)("actual message id: " + m.name()));
        }
        AptTestCase.fail();
    }

    protected void assertNoMessage() {
        List<Diagnostic<? extends JavaFileObject>> diagnostics = this.getDiagnostics();
        if (!diagnostics.isEmpty()) {
            AptTestCase.fail();
        }
    }

    protected List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        ArrayList<Diagnostic<? extends JavaFileObject>> results = new ArrayList<Diagnostic<? extends JavaFileObject>>();
        for (Diagnostic diagnostic : super.getDiagnostics()) {
            switch (diagnostic.getKind()) {
                case ERROR: 
                case WARNING: 
                case MANDATORY_WARNING: {
                    String message = diagnostic.getMessage(this.locale);
                    if (message.contains("AptinaUnitProcessor") && message.contains("'RELEASE_6'")) break;
                    results.add(diagnostic);
                }
            }
        }
        return results;
    }

    protected Message getMessageCode() {
        Iterator<Diagnostic<? extends JavaFileObject>> iterator = this.getDiagnostics().iterator();
        if (iterator.hasNext()) {
            Diagnostic<? extends JavaFileObject> diagnostic = iterator.next();
            return this.extractMessage(diagnostic);
        }
        return null;
    }

    protected Message extractMessage(Diagnostic<? extends JavaFileObject> diagnostic) {
        String code;
        String message = diagnostic.getMessage(this.locale);
        int start = message.indexOf(91);
        int end = message.indexOf(93);
        if (start > -1 && end > -1 && (code = message.substring(start + 1, end)).startsWith("DOMA")) {
            return Enum.valueOf(Message.class, code);
        }
        return null;
    }

    protected ExecutableElement createMethodElement(Class<?> clazz, String methodName, Class<?> ... parameterClasses) {
        TypeElement typeElement;
        ProcessingEnvironment env = this.getProcessingEnvironment();
        TypeElement t = typeElement = ElementUtil.getTypeElement(clazz, (ProcessingEnvironment)env);
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            for (ExecutableElement methodElement : ElementFilter.methodsIn(t.getEnclosedElements())) {
                List<? extends VariableElement> parameterElements;
                if (!methodElement.getSimpleName().contentEquals(methodName) || (parameterElements = methodElement.getParameters()).size() != parameterClasses.length) continue;
                for (int i = 0; i < parameterElements.size(); ++i) {
                    Class<?> parameterClass;
                    TypeMirror parameterType = parameterElements.get(i).asType();
                    if (TypeMirrorUtil.isSameType((TypeMirror)parameterType, parameterClass = parameterClasses[i], (ProcessingEnvironment)env)) continue;
                    return null;
                }
                return methodElement;
            }
            t = TypeMirrorUtil.toTypeElement((TypeMirror)t.getSuperclass(), (ProcessingEnvironment)env);
        }
        return null;
    }

    protected Map<String, TypeMirror> createParameterTypeMap(ExecutableElement methodElement) {
        HashMap<String, TypeMirror> result = new HashMap<String, TypeMirror>();
        for (VariableElement variableElement : methodElement.getParameters()) {
            String name = variableElement.getSimpleName().toString();
            TypeMirror type = variableElement.asType();
            result.put(name, type);
        }
        return result;
    }
}

