/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.LongWrapperVisitor;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class LongWrapper
extends AbstractWrapper<Long>
implements NumberWrapper<Long> {
    public LongWrapper() {
    }

    public LongWrapper(Long value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        super.set(v.longValue());
    }

    @Override
    public Long getDefault() {
        return 0L;
    }

    @Override
    public void increment() {
        Long value = this.getIncrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public void decrement() {
        Long value = this.getDecrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public Long getIncrementedValue() {
        Long value = (Long)this.doGet();
        if (value != null) {
            return value + 1L;
        }
        return null;
    }

    @Override
    public Long getDecrementedValue() {
        Long value = (Long)this.doGet();
        if (value != null) {
            return value - 1L;
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof LongWrapperVisitor) {
            LongWrapperVisitor v = (LongWrapperVisitor)visitor;
            return v.visitLongWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

