/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.LogicalOperatorNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.WordNode;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class LogicalOperatorNode
extends AbstractSqlNode {
    protected final WordNode wordNode;

    public LogicalOperatorNode(String word) {
        this(new WordNode(word));
    }

    protected LogicalOperatorNode(WordNode wordNode) {
        this.wordNode = wordNode;
    }

    public WordNode getWordNode() {
        return this.wordNode;
    }

    @Override
    public LogicalOperatorNode copy() {
        LogicalOperatorNode clone = new LogicalOperatorNode(this.wordNode.copy());
        for (SqlNode child : this.children) {
            clone.addNode(child.copy());
        }
        return clone;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof LogicalOperatorNodeVisitor) {
            LogicalOperatorNodeVisitor v = (LogicalOperatorNodeVisitor)visitor;
            return v.visitLogicalOperatorNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        buf.append(this.wordNode);
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        buf.append("]");
        return buf.toString();
    }
}

