/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import org.seasar.doma.internal.jdbc.dialect.StandardForUpdateTransformer;
import org.seasar.doma.internal.jdbc.sql.node.ForUpdateClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.FragmentNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlNode;

public class OracleForUpdateTransformer
extends StandardForUpdateTransformer {
    public OracleForUpdateTransformer(SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        super(forUpdateType, waitSeconds, aliases);
    }

    @Override
    public SqlNode visitSelectStatementNode(SelectStatementNode node, Void p) {
        if (this.processed) {
            return node;
        }
        this.processed = true;
        StringBuilder buf = new StringBuilder(100);
        if (this.aliases.length > 0) {
            buf.append(" of ");
            for (String alias : this.aliases) {
                buf.append(alias);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        switch (this.forUpdateType) {
            case NORMAL: {
                break;
            }
            case NOWAIT: {
                buf.append(" nowait ");
                break;
            }
            case WAIT: {
                buf.append(" wait ").append(this.waitSeconds);
                break;
            }
        }
        ForUpdateClauseNode forUpdate = new ForUpdateClauseNode(" for update");
        forUpdate.addNode(new FragmentNode(buf.toString()));
        SelectStatementNode result = new SelectStatementNode();
        result.setSelectClauseNode(node.getSelectClauseNode());
        result.setFromClauseNode(node.getFromClauseNode());
        result.setWhereClauseNode(node.getWhereClauseNode());
        result.setGroupByClauseNode(node.getGroupByClauseNode());
        result.setHavingClauseNode(node.getHavingClauseNode());
        result.setOrderByClauseNode(node.getOrderByClauseNode());
        result.setForUpdateClauseNode(forUpdate);
        return result;
    }
}

