/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.meta.DomainMeta;
import org.seasar.doma.internal.apt.util.MetaUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.BoxedPrimitiveUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainWrapper;

public class DomainTypeGenerator
extends AbstractGenerator {
    protected final DomainMeta domainMeta;
    protected final String typeName;
    protected final String metaTypeName;
    protected final String simpleMetaTypeName;
    protected final String typeParamDecl;

    public DomainTypeGenerator(ProcessingEnvironment env, TypeElement domainElement, DomainMeta domainMeta) throws IOException {
        super(env, domainElement, null, null, "_", "");
        AssertionUtil.assertNotNull(domainMeta);
        this.domainMeta = domainMeta;
        this.typeName = TypeMirrorUtil.getTypeName(domainMeta.getType(), env);
        this.metaTypeName = MetaUtil.getMetaTypeName(this.typeName);
        this.simpleMetaTypeName = MetaUtil.getSimpleMetaTypeName(this.typeName);
        this.typeParamDecl = this.makeTypeParamDecl(this.typeName);
    }

    private String makeTypeParamDecl(String typeName) {
        int pos = typeName.indexOf("<");
        if (pos == -1) {
            return "";
        }
        return typeName.substring(pos);
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        if (this.typeElement.getTypeParameters().isEmpty()) {
            this.iprint("/** */%n", new Object[0]);
        } else {
            this.iprint("/**%n", new Object[0]);
            for (TypeParameterElement typeParameterElement : this.typeElement.getTypeParameters()) {
                this.iprint(" * @param <%1$s> %1$s%n", typeParameterElement.getSimpleName());
            }
            this.iprint(" */%n", new Object[0]);
        }
        this.printGenerated();
        this.iprint("public final class %1$s implements %2$s<%3$s, %4$s> {%n", this.simpleMetaTypeName, DomainType.class.getName(), TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env), this.typeName);
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    protected void printFields() {
        if (this.domainMeta.isParametarized()) {
            this.iprint("@SuppressWarnings(\"rawtypes\")%n", new Object[0]);
        }
        this.iprint("private static final %1$s singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
    }

    protected void printConstructors() {
        this.iprint("private %1$s() {%n", this.simpleName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printMethods() {
        this.printNewDomainMethod();
        this.printGetValueClassMethod();
        this.printGetDomainClassMethod();
        this.printGetWrapperMethod();
        this.printGetSingletonInternalMethod();
        this.printWrapperClass();
    }

    protected void printNewDomainMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s newDomain(%2$s value) {%n", this.typeName, TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env));
        if (this.domainMeta.providesConstructor()) {
            if (this.domainMeta.getWrapperType().getWrappedType().isPrimitive()) {
                this.iprint("    return new %1$s(%2$s.unbox(value));%n", this.typeName, BoxedPrimitiveUtil.class.getName());
            } else {
                this.iprint("    return new %1$s(value);%n", this.typeName);
            }
        } else if (this.domainMeta.getWrapperType().getWrappedType().isPrimitive()) {
            this.iprint("    return %1$s.%2$s(%3$s.unbox(value));%n", this.domainMeta.getTypeElement().getQualifiedName(), this.domainMeta.getFactoryMethod(), BoxedPrimitiveUtil.class.getName());
        } else {
            this.iprint("    return %1$s.%2$s(value);%n", this.domainMeta.getTypeElement().getQualifiedName(), this.domainMeta.getFactoryMethod());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetValueClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getValueClass() {%n", TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env));
        this.iprint("    return %1$s.class;%n", TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env));
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetDomainClassMethod() {
        if (this.domainMeta.isParametarized()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getDomainClass() {%n", this.typeName);
        if (this.domainMeta.isParametarized()) {
            this.iprint("    Class<?> clazz = %1$s.class;%n", this.domainMeta.getTypeElement().getQualifiedName());
            this.iprint("    return (Class<%1$s>) clazz;%n", this.typeName);
        } else {
            this.iprint("    return %1$s.class;%n", this.domainMeta.getTypeElement().getQualifiedName());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetWrapperMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, %3$s> getWrapper(%3$s domain) {%n", DomainWrapper.class.getName(), TypeMirrorUtil.boxIfPrimitive(this.domainMeta.getValueType(), this.env), this.typeName);
        this.iprint("    return new Wrapper%1$s(domain);%n", this.typeParamDecl);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        if (this.domainMeta.isParametarized()) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
            this.iprint("public static %1$s %2$s getSingletonInternal() {%n", this.typeParamDecl, this.simpleMetaTypeName);
            this.iprint("    return (%1$s) singleton;%n", this.simpleMetaTypeName);
        } else {
            this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleMetaTypeName);
            this.iprint("    return singleton;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printWrapperClass() {
        WrapperGenerator wrapperGenerator = this.createWrapperGenerator();
        wrapperGenerator.generate();
    }

    protected WrapperGenerator createWrapperGenerator() {
        return new WrapperGenerator();
    }

    protected class WrapperGenerator {
        protected WrapperGenerator() {
        }

        protected void generate() {
            DomainTypeGenerator.this.iprint("private static class Wrapper%1$s extends %2$s implements %3$s<%4$s, %5$s> {%n", DomainTypeGenerator.this.typeParamDecl, DomainTypeGenerator.this.domainMeta.getWrapperType().getTypeName(), DomainWrapper.class.getName(), TypeMirrorUtil.boxIfPrimitive(DomainTypeGenerator.this.domainMeta.getValueType(), DomainTypeGenerator.this.env), DomainTypeGenerator.this.typeName);
            DomainTypeGenerator.this.print("%n", new Object[0]);
            DomainTypeGenerator.this.indent();
            this.printWrapperField();
            this.printWrapperConstructor();
            this.printWrapperDoGetMethod();
            this.pirntWrapperDoSetMethod();
            this.printWrapperGetDomainMethod();
            DomainTypeGenerator.this.unindent();
            DomainTypeGenerator.this.iprint("}%n", new Object[0]);
        }

        protected void printWrapperField() {
            DomainTypeGenerator.this.iprint("private %1$s domain;%n", DomainTypeGenerator.this.typeName);
            DomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void printWrapperConstructor() {
            DomainTypeGenerator.this.iprint("private Wrapper(%1$s domain) {%n", DomainTypeGenerator.this.typeName);
            if (DomainTypeGenerator.this.domainMeta.getWrapperType().getWrappedType().isEnum()) {
                DomainTypeGenerator.this.iprint("    super(%1$s.class);%n", TypeMirrorUtil.boxIfPrimitive(DomainTypeGenerator.this.domainMeta.getValueType(), DomainTypeGenerator.this.env));
            }
            DomainTypeGenerator.this.iprint("    this.domain = domain;%n", new Object[0]);
            DomainTypeGenerator.this.iprint("}%n", new Object[0]);
            DomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void printWrapperDoGetMethod() {
            DomainTypeGenerator.this.iprint("@Override%n", new Object[0]);
            DomainTypeGenerator.this.iprint("protected %1$s doGet() {%n", TypeMirrorUtil.boxIfPrimitive(DomainTypeGenerator.this.domainMeta.getValueType(), DomainTypeGenerator.this.env));
            DomainTypeGenerator.this.iprint("    if (domain == null) {%n", new Object[0]);
            DomainTypeGenerator.this.iprint("        return null;%n", new Object[0]);
            DomainTypeGenerator.this.iprint("    }%n", new Object[0]);
            DomainTypeGenerator.this.iprint("    return domain.%1$s();%n", DomainTypeGenerator.this.domainMeta.getAccessorMethod());
            DomainTypeGenerator.this.iprint("}%n", new Object[0]);
            DomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void pirntWrapperDoSetMethod() {
            DomainTypeGenerator.this.iprint("@Override%n", new Object[0]);
            DomainTypeGenerator.this.iprint("protected void doSet(%1$s value) {%n", TypeMirrorUtil.boxIfPrimitive(DomainTypeGenerator.this.domainMeta.getValueType(), DomainTypeGenerator.this.env));
            if (DomainTypeGenerator.this.domainMeta.providesConstructor()) {
                if (DomainTypeGenerator.this.domainMeta.getWrapperType().getWrappedType().isPrimitive()) {
                    DomainTypeGenerator.this.iprint("    domain = new %1$s(%2$s.unbox(value));%n", DomainTypeGenerator.this.typeName, BoxedPrimitiveUtil.class.getName());
                } else {
                    DomainTypeGenerator.this.iprint("    domain = new %1$s(value);%n", DomainTypeGenerator.this.typeName);
                }
            } else if (DomainTypeGenerator.this.domainMeta.getWrapperType().getWrappedType().isPrimitive()) {
                DomainTypeGenerator.this.iprint("    domain = %1$s.%2$s(%3$s.unbox(value));%n", DomainTypeGenerator.this.domainMeta.getTypeElement().getQualifiedName(), DomainTypeGenerator.this.domainMeta.getFactoryMethod(), BoxedPrimitiveUtil.class.getName());
            } else {
                DomainTypeGenerator.this.iprint("    domain = %1$s.%2$s(value);%n", DomainTypeGenerator.this.domainMeta.getTypeElement().getQualifiedName(), DomainTypeGenerator.this.domainMeta.getFactoryMethod());
            }
            DomainTypeGenerator.this.iprint("}%n", new Object[0]);
            DomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void printWrapperGetDomainMethod() {
            DomainTypeGenerator.this.iprint("@Override%n", new Object[0]);
            DomainTypeGenerator.this.iprint("public %1$s getDomain() {%n", DomainTypeGenerator.this.typeName);
            DomainTypeGenerator.this.iprint("    return domain;%n", new Object[0]);
            DomainTypeGenerator.this.iprint("}%n", new Object[0]);
        }
    }
}

