/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import example.entity._Emp;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.PostgresDialect;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.id.BuiltinSequenceIdGenerator;
import org.seasar.doma.jdbc.id.IdGenerationConfig;

public class BuiltinSequenceIdGeneratorTest
extends TestCase {
    public void test() throws Exception {
        MockConfig config = new MockConfig();
        config.setDialect((Dialect)new PostgresDialect());
        MockResultSet resultSet = config.dataSource.connection.preparedStatement.resultSet;
        resultSet.rows.add(new RowData(11L));
        BuiltinSequenceIdGenerator idGenerator = new BuiltinSequenceIdGenerator();
        idGenerator.setQualifiedSequenceName("aaa");
        idGenerator.setInitialValue(1L);
        idGenerator.setAllocationSize(1L);
        IdGenerationConfig idGenerationConfig = new IdGenerationConfig((Config)config, (EntityType)_Emp.getSingletonInternal(), "EMP", "ID");
        Long value = idGenerator.generatePreInsert(idGenerationConfig);
        BuiltinSequenceIdGeneratorTest.assertEquals((Object)new Long(11L), (Object)value);
        BuiltinSequenceIdGeneratorTest.assertEquals((String)"select nextval('aaa')", (String)config.dataSource.connection.preparedStatement.sql);
    }
}

