/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.sql.SqlTokenType;
import org.seasar.doma.internal.jdbc.sql.SqlTokenizer;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.message.Message;

public class SqlTokenizerTest
extends TestCase {
    private String lineSeparator;

    protected void setUp() throws Exception {
        super.setUp();
        this.lineSeparator = System.getProperty("line.separator");
        System.setProperty("line.separator", "\r\n");
    }

    protected void tearDown() throws Exception {
        System.setProperty("line.separator", this.lineSeparator);
        super.tearDown();
    }

    public void testEof() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testDelimiter() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where;");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.DELIMITER, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)";", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testLineComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where--aaa\r\nbbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.LINE_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"--aaa", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOL, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"\r\n", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBlockComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*+aaa*/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*+aaa*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBlockComment_empty() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /**/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/**/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testQuote() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where 'aaa'");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.QUOTE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"'aaa'", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testQuote_escaped() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where 'aaa'''");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.QUOTE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"'aaa'''", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testQuote_notClosed() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where 'aaa");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        try {
            tokenizer.next();
            SqlTokenizerTest.fail();
        }
        catch (JdbcException jdbcException) {
            // empty catch block
        }
    }

    public void testQuote_escaped_notClosed() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where 'aaa''bbb''");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        try {
            tokenizer.next();
            SqlTokenizerTest.fail();
        }
        catch (JdbcException jdbcException) {
            // empty catch block
        }
    }

    public void testUnion() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("union");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.UNION_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"union", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testExcept() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("except");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EXCEPT_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"except", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testMinus() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("minus");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.MINUS_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"minus", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testIntersect() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("intersect");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.INTERSECT_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"intersect", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testSelect() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("select");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.SELECT_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"select", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testFrom() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("from");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.FROM_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"from", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testWhere() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testGroupBy() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("group by");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.GROUP_BY_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"group by", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testHaving() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("having");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.HAVING_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"having", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testOrderBy() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("order by");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.ORDER_BY_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"order by", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testForUpdateBy() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("for update");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.FOR_UPDATE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"for update", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testAnd() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("and");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.AND_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"and", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testOr() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("or");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.OR_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"or", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBindBlockComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*aaa*/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*aaa*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBindBlockComment_followingQuote() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*aaa*/'2001-01-01 12:34:56'");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*aaa*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.QUOTE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"'2001-01-01 12:34:56'", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBindBlockComment_followingWordAndQuote() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*aaa*/timestamp'2001-01-01 12:34:56' and");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*aaa*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"timestamp'2001-01-01 12:34:56'", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.AND_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"and", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBindBlockComment_spaceIncluded() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /* aaa */bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/* aaa */", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBindBlockComment_startWithStringLiteral() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*\"aaa\"*/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*\"aaa\"*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testBindBlockComment_startWithCharLiteral() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*'a'*/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*'a'*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testIfBlockComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*%if true*/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.IF_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*%if true*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testElseifLineComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where --elseif true--bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.ELSEIF_LINE_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"--elseif true--", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testElseLineComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where --else bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.ELSE_LINE_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"--else", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testForBlockComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*%for element : list*/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.FOR_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*%for element : list*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testEndBlockComment() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where bbb/*%end*/");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.END_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/*%end*/", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testLineNumber() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("aaa\nbbb\nccc\n/* \nddd\n */");
        SqlTokenizerTest.assertEquals((int)1, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)1, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOL, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"\n", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)2, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)2, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOL, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"\n", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)3, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"ccc", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)3, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOL, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"\n", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)4, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.BIND_VARIABLE_BLOCK_COMMENT, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"/* \nddd\n */", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)6, (int)tokenizer.getLineNumber());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testColumnNumber() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("aaa bbb\nc\nd eee\n");
        SqlTokenizerTest.assertEquals((int)0, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"aaa", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)3, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)4, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"bbb", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)7, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOL, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"\n", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)0, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"c", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)1, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOL, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"\n", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)0, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"d", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)1, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHITESPACE, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)" ", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)2, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"eee", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)5, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOL, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"\n", (String)tokenizer.getToken());
        SqlTokenizerTest.assertEquals((int)0, (int)tokenizer.getPosition());
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.EOF, (Object)tokenizer.next());
        SqlTokenizerTest.assertNull((Object)tokenizer.getToken());
    }

    public void testIllegalDirective() throws Exception {
        SqlTokenizer tokenizer = new SqlTokenizer("where /*%*/bbb");
        SqlTokenizerTest.assertEquals((Object)SqlTokenType.WHERE_WORD, (Object)tokenizer.next());
        SqlTokenizerTest.assertEquals((String)"where", (String)tokenizer.getToken());
        try {
            tokenizer.next();
            SqlTokenizerTest.fail();
        }
        catch (JdbcException expected) {
            System.out.println((Object)expected);
            SqlTokenizerTest.assertEquals((Object)Message.DOMA2119, (Object)expected.getMessageResource());
        }
    }
}

