/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.meta.EnumDomainMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.EnumDomainMirror;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EnumDomainMetaFactory
implements TypeElementMetaFactory<EnumDomainMeta> {
    private final ProcessingEnvironment env;

    public EnumDomainMetaFactory(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    @Override
    public EnumDomainMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull(classElement);
        EnumDomainMirror enumDomainMirror = EnumDomainMirror.newInstance(classElement, this.env);
        if (enumDomainMirror == null) {
            throw new AptIllegalStateException("enumDomainMirror");
        }
        EnumDomainMeta enumDomainMeta = new EnumDomainMeta(classElement, classElement.asType());
        enumDomainMeta.setEnumDomainMirror(enumDomainMirror);
        this.doWrapperType(classElement, enumDomainMeta);
        this.validateClass(classElement, enumDomainMeta);
        this.validateFactoryMethod(classElement, enumDomainMeta);
        this.validateAccessorMethod(classElement, enumDomainMeta);
        return enumDomainMeta;
    }

    protected void doWrapperType(TypeElement classElement, EnumDomainMeta enumDomainMeta) {
        EnumDomainMirror enumDomainMirror;
        BasicType basicType = BasicType.newInstance(enumDomainMeta.getValueType(), this.env);
        if (basicType == null) {
            EnumDomainMirror enumDomainMirror2 = enumDomainMeta.getEnumDomainMirror();
            throw new AptException((MessageResource)Message.DOMA4102, this.env, (Element)classElement, enumDomainMirror2.getAnnotationMirror(), enumDomainMirror2.getValueType(), enumDomainMirror2.getValueTypeValue());
        }
        if (basicType.isEnum() && (enumDomainMirror = EnumDomainMirror.newInstance(classElement, this.env)) != null) {
            throw new AptException((MessageResource)Message.DOMA4178, this.env, (Element)classElement, enumDomainMirror.getAnnotationMirror(), enumDomainMirror.getValueType(), enumDomainMirror.getValueTypeValue());
        }
        enumDomainMeta.setWrapperType(basicType.getWrapperType());
    }

    protected void validateClass(TypeElement classElement, EnumDomainMeta enumDomainMeta) {
        if (classElement.getKind() != ElementKind.ENUM) {
            EnumDomainMirror enumDomainMirror = enumDomainMeta.getEnumDomainMirror();
            throw new AptException((MessageResource)Message.DOMA4174, this.env, (Element)classElement, enumDomainMirror.getAnnotationMirror(), new Object[0]);
        }
        if (classElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4180, this.env, (Element)classElement, new Object[0]);
        }
    }

    protected void validateFactoryMethod(TypeElement classElement, EnumDomainMeta enumDomainMeta) {
        for (ExecutableElement method : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals(enumDomainMeta.getFactoryMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !method.getModifiers().contains((Object)Modifier.STATIC) || method.getParameters().size() != 1) continue;
            TypeMirror parameterType = method.getParameters().get(0).asType();
            if (!this.env.getTypeUtils().isAssignable(enumDomainMeta.getValueType(), parameterType)) continue;
            TypeMirror returnType = this.env.getTypeUtils().erasure(method.getReturnType());
            if (!this.env.getTypeUtils().isAssignable(returnType, enumDomainMeta.getType())) continue;
            return;
        }
        throw new AptException((MessageResource)Message.DOMA4177, this.env, (Element)classElement, enumDomainMeta.getFactoryMethod(), classElement.asType(), enumDomainMeta.getValueType(), enumDomainMeta.getFactoryMethod());
    }

    protected void validateAccessorMethod(TypeElement classElement, EnumDomainMeta enumDomainMeta) {
        for (ExecutableElement method : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals(enumDomainMeta.getAccessorMethod()) || method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.STATIC) || !method.getParameters().isEmpty()) continue;
            TypeMirror returnType = this.env.getTypeUtils().erasure(method.getReturnType());
            if (!this.env.getTypeUtils().isAssignable(returnType, enumDomainMeta.getValueType())) continue;
            return;
        }
        throw new AptException((MessageResource)Message.DOMA4176, this.env, (Element)classElement, enumDomainMeta.getAccessorMethod(), enumDomainMeta.getValueType());
    }
}

