/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.BasicFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class DomainResultListHandler<D>
implements ResultSetHandler<List<D>> {
    protected final DomainType<?, D> domainType;

    public DomainResultListHandler(DomainType<?, D> domainType) {
        AssertionUtil.assertNotNull(domainType);
        this.domainType = domainType;
    }

    @Override
    public List<D> handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        BasicFetcher fetcher = new BasicFetcher(query);
        ArrayList domains = new ArrayList();
        while (resultSet.next()) {
            DomainWrapper<?, Object> wrapper = this.domainType.getWrapper(null);
            fetcher.fetch(resultSet, (Wrapper<?>)wrapper);
            domains.add(wrapper.getDomain());
        }
        if (query.isResultEnsured() && domains.isEmpty()) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(query.getConfig().getExceptionSqlLogType(), sql);
        }
        return domains;
    }
}

